/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.local;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.LinkOption;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.CommonAbstractFileSystem;
import tv.hd3g.transfertfiles.InvalidURLException;
import tv.hd3g.transfertfiles.local.LocalFile;

public class LocalFileSystem
extends CommonAbstractFileSystem<LocalFile> {
    private static final Logger log = LogManager.getLogger();
    private final File relativePath;

    public LocalFileSystem(File relativePath) {
        super("", relativePath.getAbsolutePath());
        try {
            this.relativePath = Objects.requireNonNull(relativePath).getCanonicalFile().toPath().toRealPath(new LinkOption[0]).normalize().toFile();
        }
        catch (IOException e) {
            throw new InvalidURLException(e);
        }
        if (!(relativePath.exists() && relativePath.isDirectory() && relativePath.canRead())) {
            throw new InvalidURLException("Can't access to \"" + relativePath + "\" directory");
        }
        log.debug("Init LocalFileSystem with {}", (Object)relativePath);
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isAvaliable() {
        return this.relativePath.exists() && this.relativePath.isDirectory() && this.relativePath.canRead();
    }

    @Override
    public LocalFile getFromPath(String path) {
        String realPath;
        String rpath = this.getPathFromRelative(path.replace('\\', '/'));
        File file = new File(this.relativePath, rpath).getAbsoluteFile().toPath().normalize().toFile();
        log.trace("Get LocalFile from path {}: {}", (Object)rpath, (Object)file);
        try {
            realPath = file.exists() ? file.toPath().toRealPath(new LinkOption[0]).normalize().toFile().getAbsolutePath() : file.getPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String rootPath = this.relativePath.getPath();
        if (!realPath.startsWith(rootPath)) {
            throw new UncheckedIOException(new IOException("Invalid root path for \"" + file.getPath() + "\""));
        }
        return new LocalFile(file, this);
    }

    File getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void connect() {
    }

    @Override
    public void close() {
    }

    public String toString() {
        String hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String rPath = this.relativePath.getAbsolutePath().replace('\\', '/');
        return "file://" + hostName + AbstractFile.normalizePath(this.getBasePath() + rPath);
    }

    @Override
    public int reusableHashCode() {
        return this.relativePath.hashCode();
    }

    @Override
    public InetAddress getHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getUsername() {
        return System.getProperty("user.name");
    }
}

