/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.CachedFileAttributes;

public class TransfertFilesSerializer {
    private static Logger log = LogManager.getLogger();
    public static final int DEFAULT_HASHCODE = 0;

    private TransfertFilesSerializer() {
    }

    public static class CachedFileAttributesDeserializer
    extends StdDeserializer<CachedFileAttributes> {
        public CachedFileAttributesDeserializer() {
            this(null);
        }

        public CachedFileAttributesDeserializer(Class<?> t) {
            super(t);
        }

        public CachedFileAttributes deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            TreeNode node = jp.getCodec().readTree(jp);
            String path = ((TextNode)node.get("path")).asText();
            long length = ((LongNode)node.get("length")).asLong();
            String lastModifiedText = ((TextNode)node.get("lastModified")).asText();
            long lastModified = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(lastModifiedText)).toEpochMilli();
            boolean exists = ((BooleanNode)node.get("exists")).asBoolean();
            boolean directory = ((BooleanNode)node.get("directory")).asBoolean();
            boolean file = ((BooleanNode)node.get("file")).asBoolean();
            boolean link = ((BooleanNode)node.get("link")).asBoolean();
            boolean special = ((BooleanNode)node.get("special")).asBoolean();
            AbstractFile abstractFile = (AbstractFile)Proxy.newProxyInstance(TransfertFilesSerializer.class.getClassLoader(), new Class[]{AbstractFile.class}, (proxy, method, args) -> {
                log.trace("Access to AbstractFile via a Proxy, {}", (Object)path);
                if (method.getName().equals("getPath")) {
                    return path;
                }
                if (method.getName().equals("hashCode")) {
                    return 0;
                }
                log.warn("This instance is a Proxy extracted from a Json, you can't access directly to it. {}", (Object)node);
                return null;
            });
            return new CachedFileAttributes(abstractFile, length, lastModified, exists, directory, file, link, special);
        }
    }

    public static class CachedFileAttributeSerializer
    extends StdSerializer<CachedFileAttributes> {
        public CachedFileAttributeSerializer() {
            this(null);
        }

        public CachedFileAttributeSerializer(Class<CachedFileAttributes> t) {
            super(t);
        }

        public void serialize(CachedFileAttributes value, JsonGenerator jg, SerializerProvider provider) throws IOException {
            jg.writeStartObject();
            jg.writeStringField("type", value.getAbstractFile().getClass().getSimpleName());
            jg.writeStringField("path", value.getPath());
            jg.writeNumberField("length", value.length());
            jg.writeStringField("lastModified", DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(value.lastModified())));
            jg.writeBooleanField("exists", value.exists());
            jg.writeBooleanField("directory", value.isDirectory());
            jg.writeBooleanField("file", value.isFile());
            jg.writeBooleanField("link", value.isLink());
            jg.writeBooleanField("special", value.isSpecial());
            jg.writeEndObject();
        }
    }
}

