/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.filters;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public enum DigestFilterHashExtraction {
    CRC32(new CRC32InstanceProvider()),
    CRC32C(new CRC32CInstanceProvider()),
    ADLER32(new ADLER32InstanceProvider()),
    MD5(new MessageDigestInstanceProvider("MD5")),
    SHA_1(new MessageDigestInstanceProvider("SHA-1")),
    SHA_224(new MessageDigestInstanceProvider("SHA-224")),
    SHA_256(new MessageDigestInstanceProvider("SHA-256")),
    SHA_384(new MessageDigestInstanceProvider("SHA-384")),
    SHA_512(new MessageDigestInstanceProvider("SHA-512")),
    SHA3_224(new MessageDigestInstanceProvider("SHA3-224")),
    SHA3_256(new MessageDigestInstanceProvider("SHA3-256")),
    SHA3_384(new MessageDigestInstanceProvider("SHA3-384")),
    SHA3_512(new MessageDigestInstanceProvider("SHA3-512")),
    BLAKE2S_224(new MessageDigestInstanceProvider("BLAKE2s-224")),
    BLAKE2S_256(new MessageDigestInstanceProvider("BLAKE2s-256")),
    BLAKE2B_384(new MessageDigestInstanceProvider("BLAKE2b-384")),
    BLAKE2B_512(new MessageDigestInstanceProvider("BLAKE2b-512"));

    private final ExtractionInstanceProvider digestProvider;

    private DigestFilterHashExtraction(ExtractionInstanceProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    public String getDigestName() {
        return this.digestProvider.getDigestName();
    }

    public boolean isAvaliable() {
        return this.digestProvider.isAvaliable();
    }

    public ExtractionInstance createInstance() {
        return this.digestProvider.createInstance();
    }

    public String toString() {
        return this.getDigestName();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static interface ExtractionInstanceProvider {
        public ExtractionInstance createInstance();

        public String getDigestName();

        public boolean isAvaliable();
    }

    static interface ExtractionInstance {
        public void update(ByteBuffer var1);

        public byte[] digest();
    }

    private static class CRC32InstanceProvider
    extends ChecksumInstanceProvider {
        private CRC32InstanceProvider() {
        }

        @Override
        public String getDigestName() {
            return "CRC-32";
        }

        @Override
        Checksum createChecksumInstance() {
            return new CRC32();
        }
    }

    private static class CRC32CInstanceProvider
    extends ChecksumInstanceProvider {
        private CRC32CInstanceProvider() {
        }

        @Override
        public String getDigestName() {
            return "CRC-32C";
        }

        @Override
        Checksum createChecksumInstance() {
            return new CRC32C();
        }
    }

    private static class ADLER32InstanceProvider
    extends ChecksumInstanceProvider {
        private ADLER32InstanceProvider() {
        }

        @Override
        public String getDigestName() {
            return "ADLER-32";
        }

        @Override
        Checksum createChecksumInstance() {
            return new Adler32();
        }
    }

    private static class MessageDigestInstanceProvider
    implements ExtractionInstanceProvider {
        private final String digestName;

        MessageDigestInstanceProvider(String digestName) {
            this.digestName = digestName;
        }

        @Override
        public String getDigestName() {
            return this.digestName;
        }

        @Override
        public boolean isAvaliable() {
            try {
                MessageDigest.getInstance(this.digestName);
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                return false;
            }
        }

        @Override
        public ExtractionInstance createInstance() {
            MessageDigest mdInstance;
            try {
                mdInstance = MessageDigest.getInstance(this.digestName);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(this.digestName, e);
            }
            return new ExtractionInstance(){

                @Override
                public void update(ByteBuffer datas) {
                    mdInstance.update(datas);
                }

                @Override
                public byte[] digest() {
                    return mdInstance.digest();
                }
            };
        }
    }

    private static abstract class ChecksumInstanceProvider
    implements ExtractionInstanceProvider {
        private ChecksumInstanceProvider() {
        }

        @Override
        public boolean isAvaliable() {
            return true;
        }

        abstract Checksum createChecksumInstance();

        @Override
        public ExtractionInstance createInstance() {
            final Checksum cksum = this.createChecksumInstance();
            return new ExtractionInstance(){

                @Override
                public void update(ByteBuffer datas) {
                    cksum.update(datas);
                }

                @Override
                public byte[] digest() {
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    buffer.putInt((int)cksum.getValue());
                    return buffer.array();
                }
            };
        }
    }
}

