/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.sftp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.CommonAbstractFileSystem;
import tv.hd3g.transfertfiles.sftp.DefaultKnownHostsVerifier;
import tv.hd3g.transfertfiles.sftp.SFTPFile;

public class SFTPFileSystem
extends CommonAbstractFileSystem<SFTPFile> {
    private static final Logger log = LogManager.getLogger();
    private final SSHClient client = new SSHClient();
    private final InetAddress host;
    private final int port;
    private final String username;
    private final Set<KeyProvider> authKeys;
    private final boolean absoluteBasePath;
    private char[] password;
    private SFTPClient sftpClient;
    private boolean statefulSFTPClient;
    private volatile boolean wasConnected = false;

    public SFTPFileSystem(InetAddress host, int port, String username, String basePath) {
        this(host, port, username, basePath, false);
    }

    public SFTPFileSystem(InetAddress host, int port, String username, String basePath, boolean absoluteBasePath) {
        super(basePath, username + "@" + host.getHostName() + ":" + port);
        this.host = Objects.requireNonNull(host);
        this.port = port;
        this.username = Objects.requireNonNull(username, "SSH username");
        if (username.length() == 0) {
            throw new IllegalArgumentException("Invalid (empty) username");
        }
        this.authKeys = new HashSet<KeyProvider>();
        this.absoluteBasePath = absoluteBasePath;
        log.debug("Init ssh client to {}", (Object)this);
        String defaultKhFile = System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "known_hosts";
        File knownHostFile = new File(System.getProperty("ssh.knownhosts", defaultKhFile));
        try {
            FileUtils.forceMkdirParent((File)knownHostFile);
            this.client.addHostKeyVerifier((HostKeyVerifier)new DefaultKnownHostsVerifier(knownHostFile));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isReusable() {
        return false;
    }

    @Override
    public synchronized boolean isAvaliable() {
        return this.client.isConnected() && this.client.isAuthenticated();
    }

    @Override
    public int getIOBufferSize() {
        if (this.sftpClient != null) {
            Session.Subsystem system = this.sftpClient.getSFTPEngine().getSubsystem();
            return Math.min(system.getLocalMaxPacketSize(), system.getRemoteMaxPacketSize());
        }
        return -1;
    }

    public String toString() {
        return "sftp://" + this.username + "@" + this.host.getHostName() + ":" + this.port + this.getBasePath();
    }

    public void setPasswordAuth(char[] password) {
        this.password = Objects.requireNonNull(password, "password");
        if (password.length == 0) {
            throw new IllegalArgumentException("Invalid (empty) password");
        }
        String strStars = SFTPFileSystem.logPassword(password);
        log.debug("Set password auth for {}: {}", (Object)this, (Object)strStars);
    }

    private static String logPassword(char[] password) {
        char[] stars = new char[password.length];
        Arrays.fill(stars, '*');
        return String.valueOf(stars);
    }

    private KeyProvider loadPrivateKey(File privateKey, char[] keyPassword) {
        try {
            if (keyPassword != null && keyPassword.length > 0) {
                String strStars = SFTPFileSystem.logPassword(keyPassword);
                log.debug("Add private key auth for {}: {}, with password {}", (Object)this, (Object)privateKey, (Object)strStars);
                return this.client.loadKeys(privateKey.getPath(), SFTPFileSystem.clonePassword(keyPassword));
            }
            log.debug("Add private key auth for {}: {}", (Object)this, (Object)privateKey);
            return this.client.loadKeys(privateKey.getPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void manuallyAddPrivatekeyAuth(File privateKey, char[] keyPassword) {
        Objects.requireNonNull(privateKey);
        if (!privateKey.exists()) {
            throw new UncheckedIOException(new FileNotFoundException(privateKey.getPath()));
        }
        if (privateKey.isDirectory()) {
            this.authKeys.addAll(Stream.of("id_rsa", "id_dsa", "id_ed25519", "id_ecdsa").map(f -> new File(privateKey, (String)f)).filter(File::exists).map(fPrivateKey -> this.loadPrivateKey((File)fPrivateKey, keyPassword)).toList());
        } else {
            this.authKeys.add(this.loadPrivateKey(privateKey, keyPassword));
        }
    }

    public void manuallyAddPrivatekeyAuth(File privateKey) {
        this.manuallyAddPrivatekeyAuth(privateKey, null);
    }

    public SSHClient getClient() {
        return this.client;
    }

    public SFTPClient getSFTPClient() {
        return this.sftpClient;
    }

    private static final char[] clonePassword(char[] password) {
        char[] disposablePassword = new char[password.length];
        System.arraycopy(password, 0, disposablePassword, 0, password.length);
        return disposablePassword;
    }

    @Override
    public void setTimeout(long duration, TimeUnit unit) {
        if (duration > 0L) {
            this.timeoutDuration = unit.toMillis(duration);
        }
        if (this.timeoutDuration > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't set a timeoutDuration > Integer.MAX_VALUE: " + this.timeoutDuration);
        }
    }

    @Override
    public synchronized void connect() {
        if (this.isAvaliable()) {
            return;
        }
        if (this.wasConnected) {
            throw new UncheckedIOException(new IOException("Client is not avaliable to use"));
        }
        log.debug("Start to connect to {}", (Object)this);
        this.wasConnected = true;
        if (this.timeoutDuration > 0L) {
            this.client.setConnectTimeout((int)this.timeoutDuration);
            this.client.setTimeout((int)this.timeoutDuration);
        }
        try {
            this.client.connect(this.host, this.port);
            if (this.password != null && this.password.length > 0) {
                log.trace("Connect to {} with password", (Object)this);
                this.client.authPassword(this.username, SFTPFileSystem.clonePassword(this.password));
            } else {
                log.trace("Connect to {} with Publickey", (Object)this);
                this.client.authPublickey(this.username, this.authKeys);
            }
            log.info("Connected to {}", (Object)this);
            this.createANewSFTPClient();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isStatefulSFTPClient() {
        return this.statefulSFTPClient;
    }

    public void setStatefulSFTPClient(boolean statefulSFTPClient) {
        this.statefulSFTPClient = statefulSFTPClient;
    }

    public synchronized void createANewSFTPClient() {
        try {
            if (this.statefulSFTPClient) {
                log.debug("Create a new stateful SFTP client for {}", (Object)this);
                this.sftpClient = this.client.newStatefulSFTPClient();
            } else {
                log.debug("Create a new SFTP client for {}", (Object)this);
                this.sftpClient = this.client.newSFTPClient();
            }
            this.sftpClient.getFileTransfer().setPreserveAttributes(false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.client.isConnected()) {
                log.info("Manually disconnect client for {}", (Object)this);
                this.client.disconnect();
            }
            this.sftpClient = null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public synchronized SFTPFile getFromPath(String path) {
        if (!this.isAvaliable()) {
            if (!this.wasConnected) {
                throw new UncheckedIOException(new IOException("Non-active SSH client, try to connect before"));
            }
            throw new UncheckedIOException(new IOException("SSH client was disconnected. Please retry with another instance."));
        }
        String aPath = this.getPathFromRelative(path);
        log.trace("Create new SFTPFile to {}/{}", (Object)this, (Object)aPath);
        return new SFTPFile(this, this.sftpClient, path, aPath);
    }

    public boolean isAbsoluteBasePath() {
        return this.absoluteBasePath;
    }

    @Override
    public InetAddress getHost() {
        return this.host;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public int reusableHashCode() {
        if (this.sftpClient == null) {
            throw new IllegalStateException("Please connect before get reusableHashCode");
        }
        return this.sftpClient.hashCode();
    }
}

