/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.json.TransfertFilesSerializer;

@JsonSerialize(using=TransfertFilesSerializer.CachedFileAttributeSerializer.class)
@JsonDeserialize(using=TransfertFilesSerializer.CachedFileAttributesDeserializer.class)
public class CachedFileAttributes {
    private final AbstractFile abstractFile;
    private final String path;
    private final long length;
    private final long lastModified;
    private final boolean exists;
    private final boolean directory;
    private final boolean file;
    private final boolean link;
    private final boolean special;
    private final int hashCode;

    public CachedFileAttributes(AbstractFile abstractFile, long length, long lastModified, boolean exists, boolean directory, boolean file, boolean link, boolean special) {
        this.abstractFile = Objects.requireNonNull(abstractFile);
        this.path = abstractFile.getPath();
        this.length = length;
        this.lastModified = lastModified;
        this.exists = exists;
        this.directory = directory;
        this.file = file;
        this.link = link;
        this.special = special;
        this.hashCode = abstractFile.hashCode();
    }

    public CachedFileAttributes(AbstractFile abstractFile) {
        this.abstractFile = Objects.requireNonNull(abstractFile);
        this.path = abstractFile.getPath();
        this.length = abstractFile.length();
        this.lastModified = abstractFile.lastModified();
        this.exists = abstractFile.exists();
        this.directory = abstractFile.isDirectory();
        this.file = abstractFile.isFile();
        this.link = abstractFile.isLink();
        this.special = abstractFile.isSpecial();
        this.hashCode = abstractFile.hashCode();
    }

    public static CachedFileAttributes notExists(AbstractFile abstractFile) {
        return new CachedFileAttributes(abstractFile, 0L, 0L, false, false, false, false, false);
    }

    public AbstractFile getAbstractFile() {
        return this.abstractFile;
    }

    public String getName() {
        return FilenameUtils.getName((String)this.path);
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getPath();
    }

    public String getParentPath() {
        return FilenameUtils.getFullPathNoEndSeparator((String)this.path);
    }

    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public long length() {
        return this.length;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isFile() {
        return this.file;
    }

    public boolean isLink() {
        return this.link;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            throw new IllegalStateException("You can't use hashCode with a disconnected item.");
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedFileAttributes other = (CachedFileAttributes)obj;
        if (this.hashCode == 0 || other.hashCode == 0) {
            throw new IllegalStateException("You can't use equals with a disconnected item.");
        }
        return this.hashCode == other.hashCode;
    }
}

