/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.ftp;

import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import tv.hd3g.transfertfiles.ftp.FTPFileSystem;

public class FTPESFileSystem
extends FTPFileSystem {
    private final boolean ignoreInvalidCertificates;
    private final FTPSClient client;
    static final SSLContext sslContextNeverCheck;

    public FTPESFileSystem(InetAddress host, int port, String username, char[] password, boolean passiveMode, boolean ignoreInvalidCertificates, String basePath) {
        super(host, port, username, password, passiveMode, basePath);
        this.ignoreInvalidCertificates = ignoreInvalidCertificates;
        this.client = ignoreInvalidCertificates ? new FTPSClient(false, sslContextNeverCheck) : new FTPSClient(false);
    }

    @Override
    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public String toString() {
        return "ftpes://" + this.username + "@" + this.host.getHostName() + ":" + this.port + this.getBasePath();
    }

    public boolean isIgnoreInvalidCertificates() {
        return this.ignoreInvalidCertificates;
    }

    static {
        try {
            sslContextNeverCheck = SSLContext.getInstance("TLS");
            sslContextNeverCheck.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Invalid key management", e);
        }
    }
}

