/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.transfertfiles.AbstractFile;

public class URLAccess {
    private final Map<String, List<String>> optionZone;
    private final String protocol;
    private final String path;
    private final String host;
    private final String username;
    private final String protectedRessourceURL;
    private final char[] password;
    private final int port;
    public static final Map<String, Integer> defaultPorts = Map.of("file", -1, "ftp", 21, "ftps", 989, "ftpes", 21, "sftp", 22);

    public URLAccess(String url) {
        URI internalURI;
        int qmarkPos = url.indexOf(63);
        try {
            if (qmarkPos == -1) {
                internalURI = new URI(URLAccess.protectPath(url));
                this.optionZone = Map.of();
            } else if (qmarkPos == url.length() - 1) {
                internalURI = new URI(URLAccess.protectPath(url.substring(0, qmarkPos)));
                this.optionZone = Map.of();
            } else {
                this.optionZone = URLAccess.splitURLQuery(url.substring(qmarkPos + 1));
                internalURI = new URI(URLAccess.protectPath(url.substring(0, qmarkPos)));
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL: \"" + url + "\"", e);
        }
        this.protocol = Objects.requireNonNull(internalURI.getScheme(), "Missing protocol");
        this.path = AbstractFile.normalizePath(Optional.ofNullable(internalURI.getPath()).orElse("/"));
        this.host = Optional.ofNullable(internalURI.getHost()).orElse("localhost");
        AbstractMap.SimpleImmutableEntry<String, String> userPasswordEntry = URLAccess.parseUserInfo(internalURI.getUserInfo(), URLAccess.getFirstKeyValue(this.optionZone, "password", ""));
        this.port = internalURI.getPort() < 1 ? defaultPorts.getOrDefault(this.protocol, -1).intValue() : internalURI.getPort();
        this.username = userPasswordEntry.getKey();
        String passwordStr = userPasswordEntry.getValue();
        this.protectedRessourceURL = url.replace(passwordStr, URLAccess.logPassword(passwordStr.length()));
        this.password = passwordStr.toCharArray();
    }

    private static String protectPath(String urlWithoutOptions) {
        return urlWithoutOptions.replace(" ", "%20").replace('\\', '/');
    }

    private static Stream<String> protectedSplit(String text) {
        ArrayList<String> list = new ArrayList<String>();
        boolean isInEscape = false;
        StringBuilder data = new StringBuilder();
        for (int pos = 0; pos < text.length(); ++pos) {
            char chr = text.charAt(pos);
            if (chr == '\"') {
                isInEscape = !isInEscape;
                continue;
            }
            if (isInEscape || !(chr == '&')) {
                data.append(chr);
                continue;
            }
            list.add(data.toString());
            data = new StringBuilder();
        }
        if (isInEscape) {
            throw new IllegalArgumentException("Missing \" on \"" + text + "\"");
        }
        if (data.length() > 0) {
            list.add(data.toString());
        }
        return list.stream().filter(Predicate.not(String::isEmpty));
    }

    private static Map<String, List<String>> splitURLQuery(String qList) {
        return URLAccess.protectedSplit(qList).map(it -> {
            int idx = it.indexOf(61);
            String key = idx > 0 ? it.substring(0, idx) : it;
            String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
            return new AbstractMap.SimpleImmutableEntry<String, Object>(key, value);
        }).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private static String getFirstKeyValue(Map<String, List<String>> query, String key, String defaultValue) {
        return query.entrySet().stream().filter(es -> key.equalsIgnoreCase((String)es.getKey())).flatMap(es -> Optional.ofNullable((List)es.getValue()).stream()).findFirst().flatMap(l -> l.stream().findFirst()).orElse(defaultValue);
    }

    private static AbstractMap.SimpleImmutableEntry<String, String> parseUserInfo(String userInfo, String defaultPassword) {
        if (userInfo == null || userInfo.equals("")) {
            return new AbstractMap.SimpleImmutableEntry<Object, String>(null, defaultPassword);
        }
        if (!userInfo.contains(":")) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(userInfo, defaultPassword);
        }
        int pos = userInfo.indexOf(58);
        if (pos == 0) {
            return new AbstractMap.SimpleImmutableEntry<Object, String>(null, userInfo);
        }
        if (pos == userInfo.length() - 1) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(userInfo, defaultPassword);
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(userInfo.substring(0, pos), userInfo.substring(pos + 1));
    }

    private static String logPassword(int size) {
        char[] stars = new char[size];
        Arrays.fill(stars, '*');
        return String.valueOf(stars);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPath() {
        return this.path;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getProtectedRessourceURL() {
        return this.protectedRessourceURL;
    }

    public char[] getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, List<String>> getOptionZone() {
        return this.optionZone;
    }
}

