/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles.filters;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.transfertfiles.BufferVault;
import tv.hd3g.transfertfiles.filters.DataExchangeFilter;
import tv.hd3g.transfertfiles.filters.DigestFilterHashExtraction;

public class DataExchangeFilterHashExtraction
implements DataExchangeFilter {
    private static final Logger log = LogManager.getLogger();
    private static final Set<DigestFilterHashExtraction> avaliableDigests = Stream.of(DigestFilterHashExtraction.values()).filter(DigestFilterHashExtraction::isAvaliable).collect(Collectors.toUnmodifiableSet());
    private final Map<DigestFilterHashExtraction, DigestFilterHashExtraction.ExtractionInstance> currentDigests;

    public DataExchangeFilterHashExtraction(DigestFilterHashExtraction ... digests) {
        this(Stream.of(digests).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet()));
    }

    public DataExchangeFilterHashExtraction(Collection<DigestFilterHashExtraction> digests) {
        this.currentDigests = digests.stream().filter(avaliableDigests::contains).collect(Collectors.toUnmodifiableMap(d -> d, DigestFilterHashExtraction::createInstance));
        if (this.currentDigests.isEmpty()) {
            throw new IllegalArgumentException("Can't init instances of " + digests);
        }
    }

    @Override
    public BufferVault applyDataFilter(boolean last, BufferVault dataSources) throws IOException {
        this.currentDigests.values().forEach(md -> md.update(dataSources.readAllToByteBuffer()));
        return new BufferVault();
    }

    public Map<DigestFilterHashExtraction, byte[]> getResults() {
        return this.currentDigests.keySet().stream().collect(Collectors.toUnmodifiableMap(d -> d, d -> this.currentDigests.get(d).digest()));
    }

    @Override
    public String getFilterName() {
        return "HashExtraction:" + this.currentDigests.keySet().stream().map(DigestFilterHashExtraction::toString).collect(Collectors.joining("+"));
    }

    static {
        Set notAvaliableDigests = Stream.of(DigestFilterHashExtraction.values()).filter(Predicate.not(avaliableDigests::contains)).collect(Collectors.toUnmodifiableSet());
        log.debug("Avaliable digests: {}, not avaliable digests: {}", avaliableDigests, notAvaliableDigests);
    }
}

