/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.transfertfiles;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import tv.hd3g.transfertfiles.AbstractFile;
import tv.hd3g.transfertfiles.AbstractFileSystem;

public abstract class CommonAbstractFileSystem<T extends AbstractFile>
implements AbstractFileSystem<T> {
    private final String basePath;
    protected long timeoutDuration;

    protected CommonAbstractFileSystem(String basePath) {
        this.basePath = AbstractFile.normalizePath(Objects.requireNonNull(basePath, "basePath"));
        this.timeoutDuration = 0L;
    }

    public String getPathFromRelative(String path) {
        return AbstractFile.normalizePath(this.basePath + AbstractFile.normalizePath(path));
    }

    public String getBasePath() {
        return this.basePath;
    }

    public int hashCode() {
        return Objects.hash(this.basePath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommonAbstractFileSystem other = (CommonAbstractFileSystem)obj;
        return Objects.equals(this.basePath, other.basePath);
    }

    @Override
    public void setTimeout(long duration, TimeUnit unit) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Can't set a timeoutDuration to " + this.timeoutDuration);
        }
        this.timeoutDuration = unit.toMillis(duration);
        if (this.timeoutDuration > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can't set a timeoutDuration > Integer.MAX_VALUE: " + this.timeoutDuration);
        }
    }

    public long getTimeout() {
        return this.timeoutDuration;
    }
}

