/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;
import org.springframework.web.bind.annotation.RestController;
import spoon.Launcher;
import spoon.reflect.CtModel;
import tv.hd3g.selfautorestdoc.RESTController;
import tv.hd3g.selfautorestdoc.RESTEntryPoint;
import tv.hd3g.selfautorestdoc.RESTMethod;

public class SelfAutoRESTDoc {
    private final ConcurrentHashMap<Class<?>, RESTController> restControllerAutoDocByClass = new ConcurrentHashMap();
    public static final String NEW_LINE = "\n";

    public void registerClass(Class<?> cl) {
        if (cl.isAnnotationPresent(RestController.class)) {
            this.restControllerAutoDocByClass.computeIfAbsent(cl, RESTController::new);
        }
    }

    public void writeToMD(File mdFile, String baseProjectURL) throws IOException {
        List<RESTEntryPoint> entryPoints = this.processAnalysis();
        try (PrintWriter pw = new PrintWriter(mdFile, StandardCharsets.UTF_8);){
            pw.print("# REST API\n");
            pw.print(NEW_LINE);
            this.writeSummary(entryPoints, pw);
            entryPoints.forEach(ep -> this.writeContent((RESTEntryPoint)ep, pw, baseProjectURL));
            pw.print(NEW_LINE);
        }
    }

    private List<RESTEntryPoint> processAnalysis() {
        Launcher launcher = new Launcher();
        launcher.addInputResource("src/main/java");
        launcher.buildModel();
        CtModel model = launcher.getModel();
        return this.restControllerAutoDocByClass.values().stream().map(c -> c.processAnalysis(model)).flatMap(controller -> controller.getMethods().stream().map(method -> new RESTEntryPoint((RESTController.RESTControllerAnalysis)controller, (RESTMethod)method))).sorted((l, r) -> (l.getPaths() + l.getVerbs()).compareTo(r.getPaths() + r.getVerbs())).toList();
    }

    private static String linkifyTitle(String title) {
        CRC32 c = new CRC32();
        c.update(title.getBytes(StandardCharsets.UTF_8));
        return "goto" + Math.abs(c.getValue());
    }

    private void writeSummary(List<RESTEntryPoint> entryPoints, PrintWriter pw) {
        pw.print("## Summary <a name=\"top\"></a>\n");
        pw.print(NEW_LINE);
        entryPoints.forEach(ep -> {
            pw.print("* [");
            String link = ep.getRequestNames() + " **" + ep.getVerbs() + "** `" + ep.getPaths() + "`";
            pw.print(link.trim());
            pw.print("](#");
            pw.print(SelfAutoRESTDoc.linkifyTitle(ep.getRequestNames() + ep.getVerbs() + ep.getPaths()));
            pw.print(")");
            pw.print(NEW_LINE);
        });
    }

    private void writeContent(RESTEntryPoint ep, PrintWriter pw, String baseProjectURL) {
        Map<String, String> urlParameters;
        pw.print(NEW_LINE);
        pw.print("## ");
        String rqname = ep.getRequestNames();
        pw.print("<a name=\"");
        pw.print(SelfAutoRESTDoc.linkifyTitle(rqname + ep.getVerbs() + ep.getPaths()));
        pw.print("\"></a> ");
        if (!rqname.isEmpty()) {
            pw.print(rqname + NEW_LINE);
        }
        pw.print("**" + ep.getVerbs() + "** ");
        pw.print("`" + ep.getPaths() + "`\n");
        pw.print(NEW_LINE);
        ep.getMethodComments().forEach(c -> {
            pw.print(c + NEW_LINE);
            pw.print(NEW_LINE);
        });
        if (ep.getMethodComments().isEmpty()) {
            pw.print(ep.getMethodName() + NEW_LINE);
            pw.print(NEW_LINE);
        }
        if (!(urlParameters = ep.getUrlParameters()).isEmpty()) {
            pw.print("Parameters:\n");
            urlParameters.forEach((n, t) -> pw.print(" - **" + n + "** " + t + NEW_LINE));
            pw.print(NEW_LINE);
        }
        String headers = ep.getHeaders();
        if (!rqname.isEmpty()) {
            pw.print("Headers: ");
            pw.print(headers + NEW_LINE);
            pw.print(NEW_LINE);
        }
        ep.getDTORequest().ifPresent(r -> {
            pw.print("```javascript\n");
            pw.print("Request body data: ");
            String consumes = ep.getConsumes();
            if (!consumes.isBlank()) {
                pw.print("\"");
                pw.print(consumes);
                pw.print("\" ");
            }
            pw.print("{\n");
            r.forEach(l -> pw.print(l + NEW_LINE));
            pw.print("}\n");
            pw.print("```\n");
            pw.print(NEW_LINE);
        });
        ep.getDTOResponse().ifPresent(r -> {
            pw.print("```javascript\n");
            pw.print("Response: ");
            String produces = ep.getProduces();
            if (!produces.isBlank()) {
                pw.print("\"");
                pw.print(produces);
                pw.print("\" ");
            }
            pw.print("{\n");
            r.forEach(l -> pw.print(l + NEW_LINE));
            pw.print("}\n");
            pw.print("```\n");
            pw.print(NEW_LINE);
        });
        String rights = ep.getRights();
        if (!rights.isEmpty()) {
            pw.print("_Mandatory rights: ");
            pw.print(rights + "_\n");
            pw.print(NEW_LINE);
        }
        pw.print("[Go to the top](#top)");
        pw.print(" &bull; [" + ep.getControllerSimpleName());
        pw.print(" :: ");
        pw.print(ep.getMethodName());
        pw.print("](" + baseProjectURL + "/");
        pw.print(ep.getControllerFullPath());
        pw.print("#");
        pw.print(ep.getLineMethodInController());
        pw.print(")");
        pw.print(NEW_LINE);
    }
}

