/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import tv.hd3g.commons.authkit.CheckBefore;
import tv.hd3g.commons.authkit.CheckOneBefore;

class AnnotationExtractor {
    private final List<MappingAnnotation> mappings = new ArrayList<MappingAnnotation>();
    private final List<Set<String>> allCheckBefore;

    AnnotationExtractor(AnnotatedElement element) {
        RequestMapping a;
        if (element.isAnnotationPresent(RequestMapping.class)) {
            a = element.getAnnotation(RequestMapping.class);
            this.mappings.add(new MappingAnnotation(a.name(), a.value(), Arrays.stream(a.method()).collect(Collectors.toUnmodifiableSet()), a.headers(), a.consumes(), a.produces()));
        }
        if (element.isAnnotationPresent(PostMapping.class)) {
            a = element.getAnnotation(PostMapping.class);
            this.mappings.add(new MappingAnnotation(a.name(), a.value(), Set.of(RequestMethod.POST), a.headers(), a.consumes(), a.produces()));
        }
        if (element.isAnnotationPresent(PatchMapping.class)) {
            a = element.getAnnotation(PatchMapping.class);
            this.mappings.add(new MappingAnnotation(a.name(), a.value(), Set.of(RequestMethod.PATCH), a.headers(), a.consumes(), a.produces()));
        }
        if (element.isAnnotationPresent(PutMapping.class)) {
            a = element.getAnnotation(PutMapping.class);
            this.mappings.add(new MappingAnnotation(a.name(), a.value(), Set.of(RequestMethod.PUT), a.headers(), a.consumes(), a.produces()));
        }
        if (element.isAnnotationPresent(DeleteMapping.class)) {
            a = element.getAnnotation(DeleteMapping.class);
            this.mappings.add(new MappingAnnotation(a.name(), a.value(), Set.of(RequestMethod.DELETE), a.headers(), a.consumes(), a.produces()));
        }
        if (element.isAnnotationPresent(GetMapping.class)) {
            a = element.getAnnotation(GetMapping.class);
            this.mappings.add(new MappingAnnotation(a.name(), a.value(), Set.of(RequestMethod.GET), a.headers(), a.consumes(), a.produces()));
        }
        this.allCheckBefore = Stream.concat(Arrays.stream((CheckBefore[])element.getAnnotationsByType(CheckBefore.class)), Arrays.stream((CheckOneBefore[])element.getAnnotationsByType(CheckOneBefore.class)).flatMap(audits -> Arrays.stream(audits.value()))).distinct().map(cb -> Arrays.stream(cb.value()).distinct().collect(Collectors.toUnmodifiableSet())).toList();
    }

    public List<MappingAnnotation> getMappings() {
        return this.mappings;
    }

    public List<Set<String>> getAllCheckBefore() {
        return this.allCheckBefore;
    }

    public static class MappingAnnotation {
        private final Optional<String> requestName;
        private final Optional<String> requestValuePath;
        private final Set<RequestMethod> requestMethods;
        private final List<String> headers;
        private final List<String> consumes;
        private final List<String> produces;

        private MappingAnnotation(String requestName, String[] requestValuePaths, Set<RequestMethod> requestMethods, String[] headers, String[] consumes, String[] produces) {
            this.requestName = Optional.ofNullable(requestName);
            this.requestValuePath = Arrays.stream(requestValuePaths).findFirst();
            this.requestMethods = requestMethods;
            this.headers = this.getOptionalList(headers);
            this.consumes = this.getOptionalList(consumes);
            this.produces = this.getOptionalList(produces);
        }

        private List<String> getOptionalList(String[] value) {
            Objects.requireNonNull(value, "value can't to be null");
            return List.of(value);
        }

        public Set<RequestMethod> getRequestMethods() {
            return this.requestMethods;
        }

        public Optional<String> getRequestName() {
            return this.requestName;
        }

        public Optional<String> getRequestValuePath() {
            return this.requestValuePath;
        }

        public List<String> getHeaders() {
            return this.headers;
        }

        public List<String> getConsumes() {
            return this.consumes;
        }

        public List<String> getProduces() {
            return this.produces;
        }
    }
}

