/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import spoon.reflect.CtModel;
import tv.hd3g.selfautorestdoc.AnnotationExtractor;
import tv.hd3g.selfautorestdoc.RESTMethod;

class RESTController {
    private final Class<?> controllerClass;

    RESTController(Class<?> controllerClass) {
        this.controllerClass = Objects.requireNonNull(controllerClass, "\"controllerClass\" can't to be null");
    }

    private static boolean isAnnotationMapping(Annotation a) {
        return a.annotationType() == RequestMapping.class || a.annotationType() == PostMapping.class || a.annotationType() == PatchMapping.class || a.annotationType() == PutMapping.class || a.annotationType() == DeleteMapping.class || a.annotationType() == GetMapping.class;
    }

    public RESTControllerAnalysis processAnalysis(CtModel model) {
        AnnotationExtractor classAnnotations = new AnnotationExtractor(this.controllerClass);
        List<RESTMethod> methods = Arrays.stream(this.controllerClass.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> Arrays.stream(m.getAnnotations()).anyMatch(RESTController::isAnnotationMapping)).map(m -> new RESTMethod((Method)m, model)).toList();
        return new RESTControllerAnalysis(classAnnotations, methods);
    }

    public class RESTControllerAnalysis {
        private final AnnotationExtractor classAnnotations;
        private final List<RESTMethod> methods;

        private RESTControllerAnalysis(AnnotationExtractor classAnnotations, List<RESTMethod> methods) {
            this.classAnnotations = classAnnotations;
            this.methods = methods;
        }

        public AnnotationExtractor getAnnotations() {
            return this.classAnnotations;
        }

        public List<RESTMethod> getMethods() {
            return this.methods;
        }

        public Class<?> getControllerClass() {
            return RESTController.this.controllerClass;
        }
    }
}

