/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import spoon.reflect.CtModel;
import spoon.reflect.code.CtComment;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import tv.hd3g.selfautorestdoc.AnnotationExtractor;
import tv.hd3g.selfautorestdoc.DtoAnalyser;

class RESTMethod {
    private final Method method;
    private final Optional<CtMethod<?>> methodType;
    private final AnnotationExtractor annotations;
    private final List<URLVariable> urlParameters;
    private final List<URLVariable> urlQueryParameters;
    private final Optional<DtoAnalyser> requestBodyType;
    private final Optional<DtoAnalyser> methodReturn;

    RESTMethod(Method method, CtModel model) {
        Optional typeEntity;
        this.method = Objects.requireNonNull(method, "\"method\" can't to be null");
        this.annotations = new AnnotationExtractor(method);
        List<Parameter> paramList = Arrays.asList(method.getParameters());
        this.urlParameters = paramList.stream().filter(p -> p.isAnnotationPresent(PathVariable.class)).map(p -> {
            PathVariable a = p.getAnnotation(PathVariable.class);
            String name = a.value();
            Class<?> type = p.getType();
            boolean required = a.required();
            return new URLVariable(name, type, required);
        }).collect(Collectors.toUnmodifiableList());
        this.urlQueryParameters = paramList.stream().filter(p -> p.isAnnotationPresent(RequestParam.class)).map(p -> {
            RequestParam a = p.getAnnotation(RequestParam.class);
            String name = a.value();
            if (name == null || name.isEmpty()) {
                name = p.getName();
            }
            Class<?> type = p.getType();
            boolean required = a.required();
            String defaultValue = a.defaultValue();
            return new URLVariable(name, type, required, defaultValue);
        }).collect(Collectors.toUnmodifiableList());
        this.requestBodyType = paramList.stream().filter(p -> p.isAnnotationPresent(RequestBody.class)).findFirst().map(Parameter::getType).flatMap(type -> model.getAllTypes().stream().filter(t -> type.getName().equals(t.getQualifiedName())).findFirst()).map(CtType::getReference).map(r -> new DtoAnalyser((CtTypeReference<?>)r, false));
        Optional<CtType> controller = model.getAllTypes().stream().filter(t -> method.getDeclaringClass().getName().equals(t.getQualifiedName())).findFirst();
        this.methodType = controller.map(t -> t.getMethodsByName(method.getName())).flatMap(m -> m.stream().findFirst());
        if (this.methodType.isEmpty()) {
            this.methodReturn = Optional.empty();
            return;
        }
        CtTypeReference mainType = this.methodType.get().getType();
        String mainReturnTypeName = mainType.getQualifiedName();
        this.methodReturn = !ResponseEntity.class.getName().equals(mainReturnTypeName) ? Optional.empty() : (!(typeEntity = mainType.getActualTypeArguments().stream().findFirst()).isPresent() ? Optional.empty() : Optional.ofNullable(new DtoAnalyser((CtTypeReference)typeEntity.get(), true)));
    }

    public AnnotationExtractor getAnnotations() {
        return this.annotations;
    }

    public Optional<DtoAnalyser> getMethodReturn() {
        return this.methodReturn;
    }

    public Method getMethod() {
        return this.method;
    }

    public Optional<DtoAnalyser> getRequestBodyType() {
        return this.requestBodyType;
    }

    public List<URLVariable> getUrlParameters() {
        return this.urlParameters;
    }

    public List<URLVariable> getUrlQueryParameters() {
        return this.urlQueryParameters;
    }

    public Optional<File> getControllerFile() {
        return this.methodType.map(CtElement::getPosition).flatMap(p -> {
            if (p.isValidPosition()) {
                return Optional.ofNullable(p.getFile());
            }
            return Optional.empty();
        });
    }

    public Optional<Integer> getMethodPosInControllerFile() {
        return this.methodType.map(CtElement::getPosition).flatMap(p -> {
            if (p.isValidPosition()) {
                return Optional.ofNullable(p.getLine());
            }
            return Optional.empty();
        });
    }

    public List<String> getMethodComments() {
        return this.methodType.map(CtElement::getComments).stream().flatMap(Collection::stream).filter(c -> CtComment.CommentType.JAVADOC.equals((Object)c.getCommentType())).map(CtComment::getContent).collect(Collectors.toUnmodifiableList());
    }

    public class URLVariable {
        private final String name;
        private final Class<?> type;
        private final boolean required;
        private final String defaultValue;

        private URLVariable(String name, Class<?> type, boolean required) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.defaultValue = null;
        }

        private URLVariable(String name, Class<?> type, boolean required, String defaultValue) {
            this.name = name;
            this.type = type;
            this.required = required;
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

