/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import tv.hd3g.selfautorestdoc.AnnotationExtractor;
import tv.hd3g.selfautorestdoc.DtoAnalyser;
import tv.hd3g.selfautorestdoc.RESTController;
import tv.hd3g.selfautorestdoc.RESTMethod;

class RESTEntryPoint {
    private final RESTController.RESTControllerAnalysis controller;
    private final RESTMethod method;

    RESTEntryPoint(RESTController.RESTControllerAnalysis controller, RESTMethod method) {
        this.controller = controller;
        this.method = method;
    }

    public String getVerbs() {
        return Stream.concat(this.controller.getAnnotations().getMappings().stream().flatMap(mapping -> mapping.getRequestMethods().stream()), this.method.getAnnotations().getMappings().stream().flatMap(mapping -> mapping.getRequestMethods().stream())).map(Enum::name).collect(Collectors.joining(", "));
    }

    public String getRights() {
        Function<Set, String> andJoin = checkBefore -> checkBefore.stream().collect(Collectors.joining(" & "));
        String controllerCB = this.controller.getAnnotations().getAllCheckBefore().stream().map(andJoin).collect(Collectors.joining(" | "));
        String methodCB = this.method.getAnnotations().getAllCheckBefore().stream().map(andJoin).collect(Collectors.joining(" | "));
        if (controllerCB.isEmpty() && methodCB.isEmpty()) {
            return "";
        }
        if (controllerCB.isEmpty() ^ methodCB.isEmpty()) {
            return controllerCB.trim() + methodCB.trim();
        }
        return "(" + controllerCB.trim() + ") & (" + methodCB.trim() + ")";
    }

    private static String ensurePaths(String ... values) {
        return Arrays.stream(values).filter(v -> v != null && !v.isBlank()).map(String::trim).map(v -> {
            int start = 0;
            if (v.startsWith("/")) {
                start = 1;
            }
            int ends = v.length();
            if (v.endsWith("/")) {
                ends = v.length() - 1;
            }
            return v.substring(start, ends);
        }).collect(Collectors.joining("/", "/", ""));
    }

    private List<String> getAllRequestValuePaths() {
        Function<AnnotationExtractor.MappingAnnotation, String> getPathsFromControllers = controllerAnnotations -> controllerAnnotations.getRequestValuePath().orElse("/");
        Function<String, Stream> flatCtrlPathMethodsPathsMapper = globalPath -> {
            Function<AnnotationExtractor.MappingAnnotation, String> getFullPathMapper = methodAnnotations -> RESTEntryPoint.ensurePaths(globalPath, methodAnnotations.getRequestValuePath().orElse(""));
            return this.method.getAnnotations().getMappings().stream().map(getFullPathMapper);
        };
        return this.controller.getAnnotations().getMappings().stream().map(getPathsFromControllers).flatMap(flatCtrlPathMethodsPathsMapper).collect(Collectors.toUnmodifiableList());
    }

    public String getPaths() {
        Stream allRequestValuePathsStream = this.getAllRequestValuePaths().stream();
        if (this.method.getUrlQueryParameters().isEmpty()) {
            return allRequestValuePathsStream.collect(Collectors.joining(", "));
        }
        String queryParameters = this.method.getUrlQueryParameters().stream().map(qp -> {
            Supplier<String> getTypeName = () -> qp.getName() + "=<" + qp.getType().getSimpleName() + ">";
            return Optional.ofNullable(qp.getDefaultValue()).map(defaultValue -> qp.getName() + "=" + defaultValue).orElseGet(getTypeName);
        }).collect(Collectors.joining("&", "?", ""));
        return allRequestValuePathsStream.collect(Collectors.joining(", ", "", queryParameters));
    }

    private Stream<String> flatMapFromAnnotationMappings(Function<AnnotationExtractor.MappingAnnotation, Stream<String>> mapper) {
        return Stream.concat(this.controller.getAnnotations().getMappings().stream().flatMap(mapper), this.method.getAnnotations().getMappings().stream().flatMap(mapper)).filter(n -> !n.isBlank());
    }

    public String getRequestNames() {
        return this.flatMapFromAnnotationMappings(a -> a.getRequestName().stream()).collect(Collectors.joining(", "));
    }

    public String getHeaders() {
        return this.flatMapFromAnnotationMappings(a -> a.getHeaders().stream()).collect(Collectors.joining(", "));
    }

    public String getProduces() {
        return this.flatMapFromAnnotationMappings(a -> a.getProduces().stream()).collect(Collectors.joining(", "));
    }

    public String getConsumes() {
        return this.flatMapFromAnnotationMappings(a -> a.getConsumes().stream()).collect(Collectors.joining(", "));
    }

    public Map<String, String> getUrlParameters() {
        return this.method.getUrlParameters().stream().collect(Collectors.toMap(RESTMethod.URLVariable::getName, k -> {
            String opt = "";
            if (!k.isRequired()) {
                opt = " not required";
            }
            return k.getType().getSimpleName() + Optional.ofNullable(k.getDefaultValue()).map(v -> " (" + v + ") ").orElse("") + opt;
        }, (v1, v2) -> v1, LinkedHashMap::new));
    }

    private String dtoFormatter(DtoAnalyser.DtoItem item) {
        StringBuilder sb = new StringBuilder();
        String prefix = StringUtils.repeat((String)"    ", (int)(item.getStratumPos() + 1));
        sb.append(prefix);
        sb.append(item.getName());
        sb.append(": ");
        switch (item.getStructuralStratum()) {
            case LIST: {
                sb.append("[");
                if (item.getSubItems() != null) {
                    sb.append("{");
                    sb.append(System.lineSeparator());
                    sb.append(item.getSubItems().stream().map(this::dtoFormatter).collect(Collectors.joining(System.lineSeparator())));
                    sb.append(System.lineSeparator());
                    sb.append(prefix);
                    sb.append("}");
                } else {
                    sb.append(item.getType());
                }
                sb.append(", ...]");
                if (item.isLastItem()) break;
                sb.append(",");
                break;
            }
            case MAP: {
                sb.append("{");
                sb.append(System.lineSeparator());
                sb.append(item.getSubItems().stream().map(this::dtoFormatter).collect(Collectors.joining(System.lineSeparator())));
                sb.append(System.lineSeparator());
                sb.append(prefix);
                sb.append("}");
                if (item.isLastItem()) break;
                sb.append(",");
                break;
            }
            default: {
                sb.append(item.getType());
                if (item.isLastItem()) break;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public Optional<List<String>> getDTORequest() {
        Optional<DtoAnalyser> bodyRequest = this.method.getRequestBodyType();
        if (bodyRequest.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(bodyRequest.get().getDtoContent().stream().map(this::dtoFormatter).collect(Collectors.toUnmodifiableList()));
    }

    public Optional<List<String>> getDTOResponse() {
        Optional<DtoAnalyser> methodReturn = this.method.getMethodReturn();
        if (methodReturn.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(methodReturn.get().getDtoContent().stream().map(this::dtoFormatter).collect(Collectors.toUnmodifiableList()));
    }

    public String getControllerSimpleName() {
        return this.controller.getControllerClass().getSimpleName();
    }

    public String getControllerFullPath() {
        String ctrl = this.controller.getControllerClass().getName().replace(".", "/");
        int hash = ctrl.indexOf(35);
        if (hash > 0) {
            return ctrl.substring(0, hash - 1);
        }
        return this.method.getControllerFile().map(cFile -> {
            String f = cFile.getAbsolutePath();
            String relative = new File("").getAbsolutePath();
            return f.substring(relative.length() + 1);
        }).map(f -> f.replace('\\', '/')).orElse(ctrl);
    }

    public String getMethodName() {
        return this.method.getMethod().getName();
    }

    public int getLineMethodInController() {
        return this.method.getMethodPosInControllerFile().orElse(1);
    }

    public List<String> getMethodComments() {
        return this.method.getMethodComments();
    }
}

