/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.hateoas.RepresentationModel;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;

class DtoAnalyser {
    private static Logger log = LogManager.getLogger();
    private static final TypeFactory typeFactory = new TypeFactory();
    private static final CtTypeReference<?> charSequenceType = typeFactory.get(CharSequence.class).getReference();
    private static final CtTypeReference<?> collectionType = typeFactory.get(Collection.class).getReference();
    private static final CtTypeReference<?> mapType = typeFactory.get(Map.class).getReference();
    private static final CtTypeReference<?> objectType = typeFactory.get(Object.class).getReference();
    private static final CtTypeReference<?> representationModelType = typeFactory.get(RepresentationModel.class).getReference();
    private final CtTypeReference<?> declaringType;
    private final boolean isResponseDto;

    DtoAnalyser(CtTypeReference<?> declaringType, boolean isResponseDto) {
        this.declaringType = Objects.requireNonNull(declaringType, "\"declaringType\" can't to be null");
        this.isResponseDto = isResponseDto;
    }

    private static String extractName(CtExecutableReference<?> eref) {
        return Optional.ofNullable((JsonProperty)eref.getAnnotation(JsonProperty.class)).map(JsonProperty::value).orElseGet(() -> {
            String simpleName = eref.getSimpleName();
            int w = 3;
            if (simpleName.startsWith("is")) {
                w = 2;
            }
            return simpleName.substring(w, w + 1).toLowerCase() + simpleName.substring(w + 1);
        });
    }

    private Stream<DtoItem> getResponseDtoContent(CtTypeReference<?> declaringType, int stratumPos) {
        CtTypeReference superClass = declaringType.getSuperclass();
        if (superClass != null && representationModelType.isSubtypeOf(superClass)) {
            return Stream.empty();
        }
        return declaringType.getAllExecutables().stream().filter(e -> {
            if (e.isConstructor()) {
                return false;
            }
            Method method = e.getActualMethod();
            if (!e.getSimpleName().startsWith("get") && !e.getSimpleName().startsWith("is") || method.getReturnType() == null || method.getParameterCount() != 0) {
                return false;
            }
            int modifiers = method.getModifiers();
            return !method.isDefault() && !Modifier.isNative(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !method.getDeclaringClass().equals(Object.class) && !method.isAnnotationPresent(JsonIgnore.class);
        }).map(eref -> new DtoItem(declaringType, DtoAnalyser.extractName(eref), eref.getType(), stratumPos));
    }

    private Stream<DtoItem> getRequestDtoContent(CtTypeReference<?> declaringType, int stratumPos) {
        List usableConstructors = declaringType.getAllExecutables().stream().filter(CtExecutableReference::isConstructor).map(CtExecutableReference::getActualConstructor).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !c.isAnnotationPresent(JsonIgnore.class)).collect(Collectors.toUnmodifiableList());
        if (usableConstructors.isEmpty() || usableConstructors.stream().anyMatch(c -> c.getParameterCount() == 0)) {
            return declaringType.getAllExecutables().stream().filter(exec -> !exec.isConstructor()).filter(e -> {
                Method method = e.getActualMethod();
                if (!e.getSimpleName().startsWith("set") || method.getParameterCount() != 1) {
                    return false;
                }
                int modifiers = method.getModifiers();
                return !method.isDefault() && !Modifier.isNative(modifiers) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !method.isAnnotationPresent(JsonIgnore.class);
            }).map(eref -> new DtoItem(declaringType, DtoAnalyser.extractName(eref), (CtTypeReference)eref.getParameters().get(0), stratumPos));
        }
        if (usableConstructors.size() > 1) {
            log.error("Can't use {} as DTO body request because there are too many ({}) accessible constructors", (Object)declaringType.getQualifiedName(), (Object)usableConstructors.size());
            return Stream.empty();
        }
        return Arrays.stream(((Constructor)usableConstructors.get(0)).getParameters()).filter(p -> !p.isAnnotationPresent(JsonIgnore.class)).filter(p -> !p.isVarArgs()).map(p -> {
            String name = Optional.ofNullable(p.getAnnotation(JsonProperty.class)).map(JsonProperty::value).orElseGet(() -> {
                if (!p.isNamePresent()) {
                    return declaringType.getQualifiedName() + "(" + p.getName() + ")";
                }
                return p.getName();
            });
            return new DtoItem(declaringType, name, typeFactory.get(p.getType()).getReference(), stratumPos);
        });
    }

    public List<DtoItem> getDtoContent(CtTypeReference<?> declaringType, int stratumPos) {
        Stream<DtoItem> dto = this.isResponseDto ? this.getResponseDtoContent(declaringType, stratumPos) : this.getRequestDtoContent(declaringType, stratumPos);
        List<DtoItem> result = dto.sorted((l, r) -> l.getName().compareTo(r.getName())).collect(Collectors.toUnmodifiableList());
        if (!result.isEmpty()) {
            result.get(result.size() - 1).setLastItem(true);
        }
        return result;
    }

    public List<DtoItem> getDtoContent() {
        return this.getDtoContent(this.declaringType, 0);
    }

    public class DtoItem {
        private final int stratumPos;
        private final StructuralStratum structuralStratum;
        private final String name;
        private final CtTypeReference<?> type;
        private final List<DtoItem> subItems;
        private boolean lastItem;

        private DtoItem(CtTypeReference<?> declaringType, String name, CtTypeReference<?> internalType, int stratumPos) {
            CtTypeReference<?> originalType;
            this.stratumPos = stratumPos;
            this.lastItem = false;
            this.name = name;
            if (internalType.isSubtypeOf(collectionType)) {
                this.structuralStratum = StructuralStratum.LIST;
                originalType = this.extractFirstTypeArguments(internalType).orElse(objectType);
            } else if (internalType.isSubtypeOf(mapType)) {
                this.structuralStratum = StructuralStratum.MAP;
                originalType = this.extractFirstTypeArguments(internalType).orElse(objectType);
            } else if (internalType.isPrimitive() || internalType.isSubtypeOf(charSequenceType) || internalType.getPackage() == null || this.isTypeIsProtected(internalType)) {
                this.structuralStratum = StructuralStratum.VALUE;
                originalType = internalType;
            } else {
                this.structuralStratum = StructuralStratum.MAP;
                originalType = internalType;
            }
            this.type = originalType.isGenerics() && !declaringType.getActualTypeArguments().isEmpty() ? (CtTypeReference)declaringType.getActualTypeArguments().get(0) : originalType;
            this.subItems = stratumPos == 10 ? null : (this.structuralStratum == StructuralStratum.MAP || this.structuralStratum == StructuralStratum.LIST && !this.isTypeIsProtected(this.type) ? DtoAnalyser.this.getDtoContent(this.type, stratumPos + 1) : null);
        }

        private boolean isTypeIsProtected(CtTypeReference<?> type) {
            if (type == null || type.getPackage() == null || type.getPackage().getQualifiedName() == null) {
                return true;
            }
            return StringUtils.startsWithAny((CharSequence)type.getPackage().getQualifiedName(), (CharSequence[])new CharSequence[]{"org.springframework", "java", "com.sun", "sun"});
        }

        private void setLastItem(boolean lastItem) {
            this.lastItem = lastItem;
        }

        public boolean isLastItem() {
            return this.lastItem;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type.getSimpleName();
        }

        public int getStratumPos() {
            return this.stratumPos;
        }

        public StructuralStratum getStructuralStratum() {
            return this.structuralStratum;
        }

        public List<DtoItem> getSubItems() {
            return this.subItems;
        }

        private Optional<CtTypeReference<?>> extractFirstTypeArguments(CtTypeReference<?> ref) {
            List typeArgs = ref.getActualTypeArguments();
            if (typeArgs.size() != 1) {
                return Optional.empty();
            }
            return Optional.ofNullable((CtTypeReference)typeArgs.get(0));
        }
    }

    public static enum StructuralStratum {
        VALUE,
        LIST,
        MAP;

    }
}

