/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RestController;
import spoon.Launcher;
import spoon.reflect.CtModel;
import tv.hd3g.selfautorestdoc.RESTController;
import tv.hd3g.selfautorestdoc.RESTEntryPoint;
import tv.hd3g.selfautorestdoc.RESTMethod;

public class SelfAutoRESTDoc {
    private final ConcurrentHashMap<Class<?>, RESTController> restControllerAutoDocByClass = new ConcurrentHashMap();
    public static final String NEW_LINE = "\n";

    public void registerClass(Class<?> cl) {
        if (cl.isAnnotationPresent(RestController.class)) {
            this.restControllerAutoDocByClass.computeIfAbsent(cl, RESTController::new);
        }
    }

    public void writeToMD(File mdFile) throws IOException {
        List<RESTEntryPoint> entryPoints = this.processAnalysis();
        try (PrintWriter pw = new PrintWriter(mdFile);){
            pw.print("# REST API\n");
            this.writeSummary(entryPoints, pw);
            entryPoints.forEach(ep -> this.writeContent((RESTEntryPoint)ep, pw));
            pw.print(NEW_LINE);
        }
    }

    private List<RESTEntryPoint> processAnalysis() {
        Launcher launcher = new Launcher();
        launcher.addInputResource("src/main/java");
        launcher.buildModel();
        CtModel model = launcher.getModel();
        return this.restControllerAutoDocByClass.values().stream().map(c -> c.processAnalysis(model)).flatMap(controller -> controller.getMethods().stream().map(method -> new RESTEntryPoint((RESTController.RESTControllerAnalysis)controller, (RESTMethod)method))).sorted((l, r) -> (l.getPaths() + l.getVerbs()).compareTo(r.getPaths() + r.getVerbs())).collect(Collectors.toUnmodifiableList());
    }

    private static String linkifyTitle(String title) {
        return title.trim().replace(' ', '-').toLowerCase().replace("?", "").replace("!", "").replace(",", "").replace(";", "").replace(":", "").replace(".", "");
    }

    private void writeSummary(List<RESTEntryPoint> entryPoints, PrintWriter pw) {
        pw.print("## Summary\n");
        entryPoints.forEach(ep -> {
            pw.print(NEW_LINE);
            pw.print(" - [");
            pw.print(ep.getRequestNames() + " **" + ep.getVerbs() + "** " + ep.getPaths());
            pw.print("](#");
            pw.print(SelfAutoRESTDoc.linkifyTitle(ep.getRequestNames() + " " + ep.getVerbs() + " " + ep.getPaths()));
            pw.print(")");
        });
        pw.print(NEW_LINE);
    }

    private void writeContent(RESTEntryPoint ep, PrintWriter pw) {
        Map<String, String> urlParameters;
        pw.print(NEW_LINE);
        pw.print(NEW_LINE);
        pw.print("## ");
        String rqname = ep.getRequestNames();
        if (!rqname.isEmpty()) {
            pw.print(rqname + NEW_LINE);
        }
        pw.print("**" + ep.getVerbs() + "** ");
        pw.print(ep.getPaths() + NEW_LINE);
        pw.print(NEW_LINE);
        ep.getMethodComments().forEach(c -> {
            pw.print(c + NEW_LINE);
            pw.print(NEW_LINE);
        });
        if (ep.getMethodComments().isEmpty()) {
            pw.print(ep.getMethodName() + NEW_LINE);
            pw.print(NEW_LINE);
        }
        if (!(urlParameters = ep.getUrlParameters()).isEmpty()) {
            pw.print("Parameters:\n");
            urlParameters.forEach((n, t) -> pw.print(" - **" + n + "** " + t + NEW_LINE));
            pw.print(NEW_LINE);
        }
        String headers = ep.getHeaders();
        if (!rqname.isEmpty()) {
            pw.print("Headers: ");
            pw.print(headers + NEW_LINE);
            pw.print(NEW_LINE);
        }
        ep.getDTORequest().ifPresent(r -> {
            pw.print("```javascript\n");
            pw.print("Request body data: ");
            String consumes = ep.getConsumes();
            if (!consumes.isBlank()) {
                pw.print("\"");
                pw.print(consumes);
                pw.print("\" ");
            }
            pw.print("{\n");
            r.forEach(l -> pw.print(l + NEW_LINE));
            pw.print("}\n");
            pw.print("```\n");
            pw.print(NEW_LINE);
        });
        ep.getDTOResponse().ifPresent(r -> {
            pw.print("```javascript\n");
            pw.print("Response: ");
            String produces = ep.getProduces();
            if (!produces.isBlank()) {
                pw.print("\"");
                pw.print(produces);
                pw.print("\" ");
            }
            pw.print("{\n");
            r.forEach(l -> pw.print(l + NEW_LINE));
            pw.print("}\n");
            pw.print("```\n");
            pw.print(NEW_LINE);
        });
        String rights = ep.getRights();
        if (!rights.isEmpty()) {
            pw.print("_Mandatory rights: ");
            pw.print(rights + "_\n");
            pw.print(NEW_LINE);
        }
        pw.print("[Go to the top](#rest-api)");
        pw.print(" &bull; [" + ep.getControllerSimpleName());
        pw.print(" :: ");
        pw.print(ep.getMethodName());
        pw.print("](/blob/master/");
        pw.print(ep.getControllerFullPath());
        pw.print("#");
        pw.print(ep.getLineMethodInController());
        pw.print(")");
    }
}

