/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.selfautorestdoc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RestController;
import spoon.Launcher;
import spoon.reflect.CtModel;
import tv.hd3g.selfautorestdoc.RESTController;
import tv.hd3g.selfautorestdoc.RESTEntryPoint;
import tv.hd3g.selfautorestdoc.RESTMethod;

public class SelfAutoRESTDoc {
    private final ConcurrentHashMap<Class<?>, RESTController> restControllerAutoDocByClass = new ConcurrentHashMap();

    public void registerClass(Class<?> cl) {
        if (cl.isAnnotationPresent(RestController.class)) {
            this.restControllerAutoDocByClass.computeIfAbsent(cl, RESTController::new);
        }
    }

    public void writeToMD(File mdFile) throws IOException {
        List<RESTEntryPoint> entryPoints = this.processAnalysis();
        try (PrintWriter pw = new PrintWriter(mdFile);){
            pw.println("# REST API");
            this.writeSummary(entryPoints, pw);
            entryPoints.forEach(ep -> this.writeContent((RESTEntryPoint)ep, pw));
            pw.println();
        }
    }

    private List<RESTEntryPoint> processAnalysis() {
        Launcher launcher = new Launcher();
        launcher.addInputResource("src/main/java");
        launcher.buildModel();
        CtModel model = launcher.getModel();
        return this.restControllerAutoDocByClass.values().stream().map(c -> c.processAnalysis(model)).flatMap(controller -> controller.getMethods().stream().map(method -> new RESTEntryPoint((RESTController.RESTControllerAnalysis)controller, (RESTMethod)method))).sorted((l, r) -> (l.getPaths() + l.getVerbs()).compareTo(r.getPaths() + r.getVerbs())).collect(Collectors.toUnmodifiableList());
    }

    private static String linkifyTitle(String title) {
        return title.trim().replace(' ', '-').toLowerCase().replace("?", "").replace("!", "").replace(",", "").replace(";", "").replace(":", "").replace(".", "");
    }

    private void writeSummary(List<RESTEntryPoint> entryPoints, PrintWriter pw) {
        pw.println("## Summary");
        entryPoints.forEach(ep -> {
            pw.println();
            pw.print(" - [");
            pw.print(ep.getRequestNames() + " **" + ep.getVerbs() + "** " + ep.getPaths());
            pw.print("](#");
            pw.print(SelfAutoRESTDoc.linkifyTitle(ep.getRequestNames() + " " + ep.getVerbs() + " " + ep.getPaths()));
            pw.print(")");
        });
        pw.println();
    }

    private void writeContent(RESTEntryPoint ep, PrintWriter pw) {
        Map<String, String> urlParameters;
        pw.println();
        pw.println();
        pw.print("## ");
        String rqname = ep.getRequestNames();
        if (!rqname.isEmpty()) {
            pw.println(rqname);
        }
        pw.print("**" + ep.getVerbs() + "** ");
        pw.println(ep.getPaths());
        pw.println();
        ep.getMethodComments().forEach(c -> {
            pw.println((String)c);
            pw.println();
        });
        if (ep.getMethodComments().isEmpty()) {
            pw.println(ep.getMethodName());
            pw.println();
        }
        if (!(urlParameters = ep.getUrlParameters()).isEmpty()) {
            pw.println("Parameters:");
            urlParameters.forEach((n, t) -> pw.println(" - **" + n + "** " + t));
            pw.println();
        }
        String headers = ep.getHeaders();
        if (!rqname.isEmpty()) {
            pw.print("Headers: ");
            pw.println(headers);
            pw.println();
        }
        ep.getDTORequest().ifPresent(r -> {
            pw.println("```javascript");
            pw.print("Request body data: ");
            String consumes = ep.getConsumes();
            if (!consumes.isBlank()) {
                pw.print("\"");
                pw.print(consumes);
                pw.print("\" ");
            }
            pw.println("{");
            r.forEach(pw::println);
            pw.println("}");
            pw.println("```");
            pw.println();
        });
        ep.getDTOResponse().ifPresent(r -> {
            pw.println("```javascript");
            pw.print("Response: ");
            String produces = ep.getProduces();
            if (!produces.isBlank()) {
                pw.print("\"");
                pw.print(produces);
                pw.print("\" ");
            }
            pw.println("{");
            r.forEach(pw::println);
            pw.println("}");
            pw.println("```");
            pw.println();
        });
        String rights = ep.getRights();
        if (!rights.isEmpty()) {
            pw.print("_Mandatory rights: ");
            pw.println(rights + "_");
            pw.println();
        }
        pw.print("[Go to the top](#rest-api)");
        pw.print(" &bull; [" + ep.getControllerSimpleName());
        pw.print(" :: ");
        pw.print(ep.getMethodName());
        pw.print("](/blob/master/");
        pw.print(ep.getControllerFullPath());
        pw.print("#");
        pw.print(ep.getLineMethodInController());
        pw.print(")");
    }
}

