/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.processlauncher.cmdline.SimpleParameters;

public class Parameters
extends SimpleParameters {
    private static final BinaryOperator<List<String>> LIST_COMBINER = (list1, list2) -> Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toUnmodifiableList());
    private String startVarTag;
    private String endVarTag;

    public Parameters() {
        this.setVarTags("<%", "%>");
    }

    public static Parameters of(String ... parameters) {
        Parameters p = new Parameters();
        p.addParameters(parameters);
        return p;
    }

    public static Parameters of(Collection<String> parameters) {
        Parameters p = new Parameters();
        p.addParameters(parameters);
        return p;
    }

    public static Parameters bulk(String ... bulkParameters) {
        Parameters p = new Parameters();
        Arrays.stream(bulkParameters).filter(Objects::nonNull).forEach(p::addBulkParameters);
        return p;
    }

    public static Parameters bulk(Collection<String> bulkParameters) {
        Parameters p = new Parameters();
        bulkParameters.forEach(p::addBulkParameters);
        return p;
    }

    public String tagVar(String varName) {
        return this.startVarTag + varName + this.endVarTag;
    }

    public Parameters setVarTags(String startVarTag, String endVarTag) {
        this.startVarTag = Objects.requireNonNull(startVarTag, "\"startVarTag\" can't to be null");
        if (startVarTag.isEmpty()) {
            throw new IllegalArgumentException("\"startVarTag\" can't to be empty");
        }
        this.endVarTag = Objects.requireNonNull(endVarTag, "\"endVarTag\" can't to be null");
        if (endVarTag.isEmpty()) {
            throw new IllegalArgumentException("\"endVarTag\" can't to be empty");
        }
        return this;
    }

    public Parameters transfertThisConfigurationTo(Parameters newInstance) {
        this.transfertThisConfigurationTo((SimpleParameters)newInstance);
        newInstance.setVarTags(this.startVarTag, this.endVarTag);
        return this;
    }

    public String getEndVarTag() {
        return this.endVarTag;
    }

    public String getStartVarTag() {
        return this.startVarTag;
    }

    public boolean isTaggedParameter(String param) {
        Objects.requireNonNull(param, "\"param\" can't to be null");
        if (param.isEmpty() || param.contains(" ")) {
            return false;
        }
        return param.startsWith(this.startVarTag) && param.endsWith(this.endVarTag);
    }

    public String extractVarNameFromTaggedParameter(String param) {
        if (!this.isTaggedParameter(param)) {
            return null;
        }
        if (param.length() == this.startVarTag.length() + this.endVarTag.length()) {
            return null;
        }
        return param.substring(this.startVarTag.length(), param.length() - this.endVarTag.length());
    }

    public String addVariable(String varName) {
        this.addParameters(this.startVarTag + varName + this.endVarTag);
        return varName;
    }

    public Parameters duplicate() {
        Parameters newInstance = new Parameters();
        newInstance.setVarTags(this.startVarTag, this.endVarTag);
        newInstance.importParametersFrom(this);
        return newInstance;
    }

    public boolean injectParamsAroundVariable(String varName, Collection<String> addBefore, Collection<String> addAfter) {
        Objects.requireNonNull(varName, "\"varName\" can't to be null");
        Objects.requireNonNull(addBefore, "\"addBefore\" can't to be null");
        Objects.requireNonNull(addAfter, "\"addAfter\" can't to be null");
        AtomicBoolean isDone = new AtomicBoolean(false);
        List<String> newParameters = this.getParameters().stream().reduce(Collections.unmodifiableList(new ArrayList()), (list, arg) -> {
            String currentVarName;
            if (this.isTaggedParameter((String)arg) && (currentVarName = this.extractVarNameFromTaggedParameter((String)arg)) != null && currentVarName.equals(varName)) {
                isDone.set(true);
                return Stream.concat(list.stream(), Stream.concat(Stream.concat(addBefore.stream(), Stream.of(arg)), addAfter.stream())).collect(Collectors.toUnmodifiableList());
            }
            return Stream.concat(list.stream(), Stream.of(arg)).collect(Collectors.toUnmodifiableList());
        }, LIST_COMBINER);
        this.replaceParameters(newParameters);
        return isDone.get();
    }

    public Parameters removeVariables(boolean removeParamsIfNoVarToInject) {
        return this.injectVariables(Collections.emptyMap(), removeParamsIfNoVarToInject);
    }

    public Parameters injectVariables(Map<String, Parameters> varsToInject, boolean removeParamsIfNoVarToInject) {
        List<String> newParameters = removeParamsIfNoVarToInject ? this.getParameters().stream().reduce(Collections.unmodifiableList(new ArrayList()), (list, varName) -> {
            if (this.isTaggedParameter((String)varName)) {
                if (varsToInject.containsKey(varName)) {
                    return Stream.concat(list.stream(), ((Parameters)varsToInject.get(varName)).getParameters().stream()).collect(Collectors.toUnmodifiableList());
                }
                if (list.isEmpty() || !this.isParameterArgIsAParametersKey((String)list.get(list.size() - 1))) {
                    return list;
                }
                return list.stream().limit((long)list.size() - 1L).collect(Collectors.toUnmodifiableList());
            }
            return Stream.concat(list.stream(), Stream.of(varName)).collect(Collectors.toUnmodifiableList());
        }, LIST_COMBINER) : this.computeInjectVariablesKeepParams(varsToInject);
        this.replaceParameters(newParameters);
        return this;
    }

    private List<String> computeInjectVariablesKeepParams(Map<String, Parameters> varsToInject) {
        List<String> newParameters = this.getParameters().stream().flatMap(arg -> {
            if (this.isTaggedParameter((String)arg)) {
                if (varsToInject.containsKey(arg)) {
                    return ((Parameters)varsToInject.get(arg)).getParameters().stream();
                }
                return Stream.empty();
            }
            return Stream.of(arg);
        }).collect(Collectors.toUnmodifiableList());
        return newParameters;
    }
}

