/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import tv.hd3g.processlauncher.EndStatus;
import tv.hd3g.processlauncher.ExecutionCallbacker;
import tv.hd3g.processlauncher.ExternalProcessStartup;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.ProcessLifeCycleException;
import tv.hd3g.processlauncher.Processlauncher;
import tv.hd3g.processlauncher.StdInInjection;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;

public class ProcesslauncherLifecycle {
    private static final String LOG_FORCE_TO_CLOSE_PROCESS = "Force to close process {}";
    private static final String LOG_CLOSE_MANUALLY_PROCESS = "Close manually process {}";
    private static Logger log = LogManager.getLogger();
    private static final Executor END_EXEC_CALLBACK;
    private static final AtomicLong END_EXEC_CALLBACK_COUNT;
    private final Processlauncher launcher;
    private final Process process;
    private final Thread shutdownHook;
    private final String fullCommandLine;
    private final long startDate;
    private volatile boolean processWasKilled;
    private volatile boolean processWasStoppedBecauseTooLongTime;
    private volatile long endDate;
    private StdInInjection stdInInjection;

    ProcesslauncherLifecycle(Processlauncher launcher) throws IOException {
        this.launcher = launcher;
        this.processWasKilled = false;
        this.processWasStoppedBecauseTooLongTime = false;
        this.fullCommandLine = launcher.getFullCommandLine();
        ProcessBuilder pBuilder = launcher.getProcessBuilder();
        Optional<ExternalProcessStartup> externalProcessStartup = launcher.getExternalProcessStartup();
        if (externalProcessStartup.isPresent()) {
            this.process = externalProcessStartup.get().startProcess(pBuilder);
            Objects.requireNonNull(this.process, "Can't manage null process");
        } else {
            this.process = pBuilder.start();
            log.info("Start process # {} {}", (Object)this.process.pid(), (Object)this.fullCommandLine);
        }
        this.startDate = System.currentTimeMillis();
        this.shutdownHook = new Thread(() -> {
            log.warn("Try to kill {}", (Object)this);
            this.killProcessTree(this.process);
        });
        this.shutdownHook.setDaemon(false);
        this.shutdownHook.setPriority(10);
        this.shutdownHook.setName("ShutdownHook for " + this.toString());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        launcher.getExecutionTimeLimiter().ifPresent(etl -> etl.addTimesUp(this, this.process));
        List<ExecutionCallbacker> executionCallbackers = launcher.getExecutionCallbackers();
        executionCallbackers.forEach(ec -> ec.postStartupExecution(this));
        launcher.getCaptureStandardOutput().ifPresent(cso -> {
            cso.stdOutStreamConsumer(this.process.getInputStream(), this);
            cso.stdErrStreamConsumer(this.process.getErrorStream(), this);
        });
        this.process.onExit().thenRunAsync(() -> {
            long msec;
            String pName = this.getExecNameWithoutExt();
            String pid = this.getPID().map(p -> "#" + p).orElse("");
            String status = this.getEndStatus().toString().toLowerCase();
            Object retnr = "";
            if (!this.isCorrectlyDone()) {
                retnr = " return " + this.getExitCode();
            }
            Object dur = "";
            dur = this.getUptime(TimeUnit.SECONDS) == 0L ? ((msec = this.getCPUDuration(TimeUnit.MILLISECONDS)) == 0L ? "" : " in " + msec + " msec") : " in " + this.getUptime(TimeUnit.SECONDS) + " sec";
            log.info("End exec process {}{} {}{}{}", (Object)pName, (Object)pid, (Object)status, retnr, dur);
            this.endDate = System.currentTimeMillis();
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            externalProcessStartup.ifPresent(eps -> eps.onEndProcess(this));
            executionCallbackers.forEach(ec -> ec.onEndExecution(this));
        }, END_EXEC_CALLBACK);
    }

    public String getExecNameWithoutExt() {
        String execName = this.launcher.getExecutableName();
        if (ExecutableFinder.WINDOWS_EXEC_EXTENSIONS.stream().anyMatch(ext -> execName.toLowerCase().endsWith(ext.toLowerCase()))) {
            return execName.substring(0, execName.length() - 4);
        }
        return execName;
    }

    public long getStartDate() {
        return this.getProcess().info().startInstant().flatMap(i -> Optional.ofNullable(i.toEpochMilli())).orElse(this.startDate);
    }

    public String toString() {
        if (this.process.isAlive()) {
            return "Process" + this.getPID().map(pid -> " #" + pid).orElse("") + " " + this.fullCommandLine + " ; since " + this.getUptime(TimeUnit.SECONDS) + " sec";
        }
        return "Exec " + this.getEndStatus() + " " + this.fullCommandLine;
    }

    private static String processHandleToString(ProcessHandle processHandle, boolean verbose) {
        if (verbose) {
            return processHandle.info().command().orElse("<?>") + " #" + processHandle.pid() + " by " + processHandle.info().user().orElse("<?>") + " since " + processHandle.info().totalCpuDuration().orElse(Duration.ZERO).getSeconds() + " sec";
        }
        return processHandle.info().commandLine().orElse("<?>") + " #" + processHandle.pid();
    }

    private void killProcessTree(Process process) {
        if (!process.isAlive()) {
            return;
        }
        log.debug("Internal kill {}", (Object)this);
        List<ProcessHandle> cantKill = process.descendants().filter(ProcessHandle::isAlive).filter(processHandle -> {
            if (log.isDebugEnabled()) {
                log.info(LOG_CLOSE_MANUALLY_PROCESS, new Supplier[]{() -> ProcesslauncherLifecycle.processHandleToString(processHandle, true)});
            } else if (log.isInfoEnabled()) {
                log.info(LOG_CLOSE_MANUALLY_PROCESS, new Supplier[]{() -> ProcesslauncherLifecycle.processHandleToString(processHandle, false)});
            }
            return !processHandle.destroy();
        }).filter(processHandle -> {
            if (log.isDebugEnabled()) {
                log.info(LOG_FORCE_TO_CLOSE_PROCESS, new Supplier[]{() -> ProcesslauncherLifecycle.processHandleToString(processHandle, true)});
            } else if (log.isInfoEnabled()) {
                log.info(LOG_FORCE_TO_CLOSE_PROCESS, new Supplier[]{() -> ProcesslauncherLifecycle.processHandleToString(processHandle, false)});
            }
            return !processHandle.destroyForcibly();
        }).collect(Collectors.toUnmodifiableList());
        if (process.isAlive()) {
            log.info(LOG_CLOSE_MANUALLY_PROCESS, new Supplier[]{() -> ProcesslauncherLifecycle.processHandleToString(process.toHandle(), true)});
            if (!process.toHandle().destroy()) {
                log.info(LOG_FORCE_TO_CLOSE_PROCESS, new Supplier[]{() -> ProcesslauncherLifecycle.processHandleToString(process.toHandle(), true)});
                if (!process.toHandle().destroyForcibly()) {
                    throw new ProcessLifeCycleException("Can't close process " + ProcesslauncherLifecycle.processHandleToString(process.toHandle(), true));
                }
            }
        }
        if (!cantKill.isEmpty()) {
            cantKill.forEach(processHandle -> log.error("Can't force close process {}", new Supplier[]{() -> ProcesslauncherLifecycle.processHandleToString(processHandle, true)}));
            throw new ProcessLifeCycleException("Can't close process " + this.toString() + " for PID " + cantKill.stream().map(ProcessHandle::pid).map(String::valueOf).collect(Collectors.joining(", ")));
        }
    }

    public Processlauncher getLauncher() {
        return this.launcher;
    }

    public Process getProcess() {
        return this.process;
    }

    public EndStatus getEndStatus() {
        if (this.process.isAlive()) {
            return EndStatus.NOT_YET_DONE;
        }
        if (this.processWasKilled) {
            return EndStatus.KILLED;
        }
        if (this.processWasStoppedBecauseTooLongTime) {
            return EndStatus.TOO_LONG_EXECUTION_TIME;
        }
        if (this.launcher.isExecCodeMustBeZero() && this.process.exitValue() != 0) {
            return EndStatus.DONE_WITH_ERROR;
        }
        return EndStatus.CORRECTLY_DONE;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public long getUptime(TimeUnit unit) {
        if (this.endDate > 0L) {
            return unit.convert(this.endDate - this.getStartDate(), TimeUnit.MILLISECONDS);
        }
        return unit.convert(System.currentTimeMillis() - this.getStartDate(), TimeUnit.MILLISECONDS);
    }

    public long getCPUDuration(TimeUnit unit) {
        return unit.convert(this.process.info().totalCpuDuration().orElse(Duration.ZERO).toMillis(), TimeUnit.MILLISECONDS);
    }

    public boolean isKilled() {
        return this.processWasKilled;
    }

    public boolean isTooLongTime() {
        return this.processWasStoppedBecauseTooLongTime;
    }

    ProcesslauncherLifecycle runningTakesTooLongTimeStopIt() {
        this.processWasStoppedBecauseTooLongTime = true;
        this.killProcessTree(this.process);
        return this;
    }

    public ProcesslauncherLifecycle kill() {
        if (!this.process.isAlive()) {
            return this;
        }
        this.processWasKilled = true;
        this.killProcessTree(this.process);
        return this;
    }

    public ProcesslauncherLifecycle waitForEnd() {
        try {
            this.process.waitFor();
            while (this.process.isAlive()) {
                Thread.onSpinWait();
            }
        }
        catch (InterruptedException e) {
            throw new ProcessLifeCycleException("Can't wait the end of " + this.fullCommandLine, e);
        }
        return this;
    }

    public ProcesslauncherLifecycle waitForEnd(long timeout, TimeUnit unit) {
        try {
            this.process.waitFor(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new ProcessLifeCycleException("Can't wait the end of " + this.fullCommandLine, e);
        }
        return this;
    }

    public ProcesslauncherLifecycle checkExecution() {
        this.waitForEnd();
        if (!this.isCorrectlyDone()) {
            throw new InvalidExecution(this);
        }
        return this;
    }

    public synchronized StdInInjection getStdInInjection() {
        if (this.stdInInjection == null) {
            this.stdInInjection = new StdInInjection(this.process.getOutputStream());
        }
        return this.stdInInjection;
    }

    String getFullCommandLine() {
        return this.fullCommandLine;
    }

    public boolean isCorrectlyDone() {
        return this.getEndStatus().equals((Object)EndStatus.CORRECTLY_DONE);
    }

    public Integer getExitCode() {
        while (this.getProcess().isAlive()) {
            Thread.onSpinWait();
        }
        while (true) {
            try {
                return this.getProcess().exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (!e.getMessage().equalsIgnoreCase("process has not exited")) {
                    throw e;
                }
                Thread.onSpinWait();
                continue;
            }
            break;
        }
    }

    public Optional<String> getUserExec() {
        return this.getProcess().info().user();
    }

    public Optional<Long> getPID() {
        try {
            return Optional.ofNullable(this.getProcess().pid());
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    public Boolean isRunning() {
        return this.getProcess().isAlive();
    }

    static {
        END_EXEC_CALLBACK_COUNT = new AtomicLong(0L);
        END_EXEC_CALLBACK = Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r);
            t.setPriority(1);
            t.setDaemon(true);
            t.setName("EndProcessExecCallback#" + END_EXEC_CALLBACK_COUNT.getAndIncrement());
            return t;
        });
    }
}

