/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import tv.hd3g.processlauncher.CaptureStandardOutputText;
import tv.hd3g.processlauncher.CapturedStdOutErrTextInteractive;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.CapturedStreams;
import tv.hd3g.processlauncher.ExecutableToolRunning;
import tv.hd3g.processlauncher.LineEntry;
import tv.hd3g.processlauncher.ProcessLifeCycleException;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.cmdline.CommandLine;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public interface ExecutableTool {
    public Parameters getReadyToRunParameters();

    public String getExecutableName();

    default public void beforeRun(ProcesslauncherBuilder processBuilder) {
    }

    default public Predicate<String> filterOutErrorLines() {
        return p -> true;
    }

    default public ExecutableToolRunning execute(ExecutableFinder executableFinder, Logger log, Function<LineEntry, Level> levelMapper) {
        String executableName = this.getExecutableName();
        try {
            CapturedStdOutErrTextRetention textRetention;
            CommandLine cmd = new CommandLine(executableName, this.getReadyToRunParameters(), executableFinder);
            ProcesslauncherBuilder builder = new ProcesslauncherBuilder(cmd);
            if (log == null) {
                textRetention = new CapturedStdOutErrTextRetention();
                builder.getSetCaptureStandardOutputAsOutputText(CapturedStreams.BOTH_STDOUT_STDERR).addObserver(textRetention);
            } else {
                CaptureStandardOutputText capture = builder.getSetCaptureStandardOutputAsOutputText();
                capture.addObserver(new CapturedStdOutErrTextInteractive(line -> {
                    Level level = (Level)levelMapper.apply((LineEntry)line);
                    if (level != null && log.isEnabled(level)) {
                        log.log(level, line);
                    }
                    return null;
                }));
                textRetention = new CapturedStdOutErrTextRetention();
                capture.addObserver(textRetention);
            }
            this.beforeRun(builder);
            return new ExecutableToolRunning(textRetention, builder.start(), this);
        }
        catch (IOException e) {
            throw new ProcessLifeCycleException("Can't start " + executableName, e);
        }
    }

    default public ExecutableToolRunning execute(ExecutableFinder executableFinder) {
        return this.execute(executableFinder, null, null);
    }
}

