/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.cmdline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableFinder {
    private static final Logger log = LoggerFactory.getLogger(ExecutableFinder.class);
    public static final Predicate<File> isValidDirectory = f -> f.exists() && f.isDirectory() && f.canRead();
    public static final List<String> WINDOWS_EXEC_EXTENSIONS;
    public static final List<File> GLOBAL_DECLARED_DIRS;
    private final Deque<File> paths;
    private final Map<String, File> declaredInConfiguration = Collections.synchronizedMap(new LinkedHashMap());
    private final boolean isWindowsStylePath = File.separator.equals("\\");

    public ExecutableFinder() {
        this.paths = new ConcurrentLinkedDeque<File>(GLOBAL_DECLARED_DIRS);
        this.addLocalPath("/bin");
        this.addLocalPath("/App/bin");
        this.paths.add(new File(System.getProperty("user.dir")));
        this.paths.addAll(Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(File::new).filter(isValidDirectory).toList());
        this.paths.addAll(Arrays.stream(System.getenv("PATH").split(File.pathSeparator)).map(File::new).filter(isValidDirectory).toList());
        List newList = this.paths.stream().distinct().toList();
        this.paths.clear();
        this.paths.addAll(newList);
        log.trace("Full path: {}", (Object)this.paths.stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator)));
    }

    public String getFullPathToString() {
        return this.paths.stream().map(File::getPath).reduce((left, right) -> left + File.pathSeparator + right).orElse("");
    }

    public List<File> getFullPath() {
        return this.paths.stream().toList();
    }

    public ExecutableFinder addLocalPath(String relativeUserHomePath) {
        String converted = this.isWindowsStylePath ? relativeUserHomePath.replace("/", "\\\\") : relativeUserHomePath.replace("\\\\", "/");
        String userHome = System.getProperty("user.home");
        File f = new File(userHome + File.separator + converted).getAbsoluteFile();
        return this.addPath(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableFinder addPath(File filePath) {
        File f = filePath.getAbsoluteFile();
        if (isValidDirectory.test(f)) {
            ExecutableFinder executableFinder = this;
            synchronized (executableFinder) {
                log.debug("Register path: {}", (Object)f.getPath());
                this.paths.addFirst(f);
            }
        }
        return this;
    }

    private boolean validExec(File exec) {
        if (!(exec.exists() && exec.isFile() && exec.canRead())) {
            return false;
        }
        return exec.canExecute();
    }

    public ExecutableFinder registerExecutable(String name, File fullPath) throws IOException {
        if (!this.validExec(fullPath)) {
            throw new IOException("Invalid declaredInConfiguration executable: " + name + " can't be correctly found in " + fullPath);
        }
        this.declaredInConfiguration.put(name, fullPath);
        return this;
    }

    public File get(String name) throws FileNotFoundException {
        if (this.declaredInConfiguration.containsKey(name)) {
            return this.declaredInConfiguration.get(name);
        }
        File exec = new File(name);
        if (this.validExec(exec)) {
            return exec;
        }
        List<File> allFileCandidates = Stream.concat(this.declaredInConfiguration.values().stream().map(File::getParentFile), this.paths.stream()).map(dir -> new File(dir + File.separator + name).getAbsoluteFile()).distinct().toList();
        if (!this.isWindowsStylePath) {
            return allFileCandidates.stream().filter(this::validExec).findFirst().orElseThrow(() -> new FileNotFoundException("Can't found executable \"" + name + "\""));
        }
        return (File)allFileCandidates.stream().flatMap(file -> {
            boolean hasAlreadyValidExt = WINDOWS_EXEC_EXTENSIONS.stream().anyMatch(ext -> file.getName().toLowerCase().endsWith("." + ext.toLowerCase()));
            if (hasAlreadyValidExt) {
                if (this.validExec((File)file)) {
                    return Stream.of(file);
                }
                return Stream.empty();
            }
            return WINDOWS_EXEC_EXTENSIONS.stream().flatMap(ext -> Stream.of(new File(file + "." + ext.toLowerCase()), new File(file + "." + ext.toUpperCase()))).filter(this::validExec);
        }).findFirst().orElseThrow(() -> new FileNotFoundException("Can't found executable \"" + name + "\""));
    }

    static {
        if (System.getenv().containsKey("PATHEXT")) {
            String pathExt = System.getenv("PATHEXT");
            if (pathExt.indexOf(59) >= 0) {
                WINDOWS_EXEC_EXTENSIONS = Arrays.stream(pathExt.split(";")).map(ext -> ext.toLowerCase().substring(1)).toList();
            } else {
                log.warn("Invalid PATHEXT env.: {}", (Object)pathExt);
                WINDOWS_EXEC_EXTENSIONS = List.of("exe", "com", "cmd", "bat");
            }
        } else {
            WINDOWS_EXEC_EXTENSIONS = List.of("exe", "com", "cmd", "bat");
        }
        String searchdir = System.getProperty("execfinder.searchdir");
        if (searchdir != null && !searchdir.equals("")) {
            GLOBAL_DECLARED_DIRS = Arrays.stream(searchdir.split(File.pathSeparator)).map(File::new).filter(isValidDirectory).map(File::getAbsoluteFile).toList();
            log.debug("Specific executable path declared via system property: {}", (Object)GLOBAL_DECLARED_DIRS.stream().map(File::getPath).collect(Collectors.joining(", ")));
        } else {
            GLOBAL_DECLARED_DIRS = List.of();
        }
    }
}

