/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import tv.hd3g.processlauncher.CapturedStreams;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class LineEntry {
    private final long date;
    private final String line;
    private final boolean stdErr;
    private final ProcesslauncherLifecycle source;

    LineEntry(long date, String line, boolean stdErr, ProcesslauncherLifecycle source) {
        this.line = line;
        this.stdErr = stdErr;
        this.source = source;
        this.date = date;
    }

    public long getTimeAgo() {
        return this.date - this.source.getStartDate();
    }

    public long getDate() {
        return this.date;
    }

    public String getLine() {
        return this.line;
    }

    public ProcesslauncherLifecycle getSource() {
        return this.source;
    }

    public boolean isStdErr() {
        return this.stdErr;
    }

    boolean canUseThis(CapturedStreams choosedStream) {
        return this.stdErr && choosedStream.canCaptureStderr() || !this.stdErr && choosedStream.canCaptureStdout();
    }

    public String toString() {
        String execName = this.source.getLauncher().getExecutableName();
        if (this.stdErr) {
            return execName + " \u274c " + this.line;
        }
        return execName + " \u2705 " + this.line;
    }

    public static LineEntry makeStdOut(String line, ProcesslauncherLifecycle source) {
        return new LineEntry(System.currentTimeMillis(), line, false, source);
    }

    public static LineEntry makeStdErr(String line, ProcesslauncherLifecycle source) {
        return new LineEntry(System.currentTimeMillis(), line, true, source);
    }
}

