/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.util.stream.Collectors;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.ExecutableTool;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class ExecutableToolRunning {
    private final CapturedStdOutErrTextRetention textRetention;
    private final ProcesslauncherLifecycle lifecyle;
    private final ExecutableTool execTool;

    ExecutableToolRunning(CapturedStdOutErrTextRetention textRetention, ProcesslauncherLifecycle lifecyle, ExecutableTool execTool) {
        this.textRetention = textRetention;
        this.lifecyle = lifecyle;
        this.execTool = execTool;
    }

    public CapturedStdOutErrTextRetention getTextRetention() {
        return this.textRetention;
    }

    public ProcesslauncherLifecycle getLifecyle() {
        return this.lifecyle;
    }

    public CapturedStdOutErrTextRetention checkExecutionGetText() {
        try {
            this.lifecyle.checkExecution();
            this.textRetention.waitForClosedStreams();
            return this.textRetention;
        }
        catch (InvalidExecution e) {
            throw e.injectStdErr(this.textRetention.getStderrLines(false).filter(this.execTool.filterOutErrorLines()).map(String::trim).collect(Collectors.joining("|")));
        }
    }

    public ExecutableToolRunning waitForEnd() {
        this.lifecyle.waitForEnd();
        return this;
    }

    public ExecutableToolRunning waitForEndAndCheckExecution() {
        this.waitForEnd();
        try {
            this.lifecyle.checkExecution();
        }
        catch (InvalidExecution e) {
            throw e.injectStdErr(this.textRetention.getStderrLines(false).filter(this.execTool.filterOutErrorLines()).map(String::trim).collect(Collectors.joining("|")));
        }
        return this;
    }
}

