/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.processlauncher.CapturedStdOutErrText;
import tv.hd3g.processlauncher.LineEntry;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class CapturedStdOutErrTextInteractive
extends CapturedStdOutErrText {
    private static final Logger log = LoggerFactory.getLogger(CapturedStdOutErrTextInteractive.class);
    private final Function<LineEntry, String> interactive;
    private final Charset destCharset;

    public CapturedStdOutErrTextInteractive(Function<LineEntry, String> interactive, Charset destCharset) {
        this.interactive = Objects.requireNonNull(interactive, "\"interactive\" can't to be null");
        this.destCharset = Objects.requireNonNull(destCharset, "\"destCharset\" can't to be null");
    }

    public CapturedStdOutErrTextInteractive(Function<LineEntry, String> interactive) {
        this(interactive, Charset.defaultCharset());
    }

    @Override
    void onText(LineEntry lineEntry) {
        String result = this.interactive.apply(lineEntry);
        ProcesslauncherLifecycle source = lineEntry.getSource();
        if (result != null && source.isRunning().booleanValue()) {
            try {
                source.getStdInInjection().println(result, this.destCharset);
            }
            catch (IOException e) {
                log.error("Can't send some text to process", (Throwable)e);
            }
        }
    }
}

