/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import tv.hd3g.processlauncher.CaptureStandardOutput;
import tv.hd3g.processlauncher.CapturedStdOutErrText;
import tv.hd3g.processlauncher.CapturedStreams;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.StreamParser;

public class CaptureStandardOutputText
implements CaptureStandardOutput {
    private final CapturedStreams captureOutStreamsBehavior;
    private final List<CapturedStdOutErrText> observers;

    CaptureStandardOutputText(CapturedStreams captureOutStreamsBehavior) {
        this.captureOutStreamsBehavior = captureOutStreamsBehavior;
        this.observers = new ArrayList<CapturedStdOutErrText>();
    }

    CaptureStandardOutputText() {
        this(CapturedStreams.BOTH_STDOUT_STDERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(CapturedStdOutErrText observer) {
        List<CapturedStdOutErrText> list = this.observers;
        synchronized (list) {
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamParser stdOutStreamConsumer(InputStream processInputStream, ProcesslauncherLifecycle source) {
        if (this.captureOutStreamsBehavior.canCaptureStdout()) {
            StreamParser t = new StreamParser(processInputStream, false, source, this.observers);
            t.start();
            List<CapturedStdOutErrText> list = this.observers;
            synchronized (list) {
                this.observers.forEach(o -> o.setWatchThreadStdout(t));
            }
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamParser stdErrStreamConsumer(InputStream processInputStream, ProcesslauncherLifecycle source) {
        if (this.captureOutStreamsBehavior.canCaptureStderr()) {
            StreamParser t = new StreamParser(processInputStream, true, source, this.observers);
            t.start();
            List<CapturedStdOutErrText> list = this.observers;
            synchronized (list) {
                this.observers.forEach(o -> o.setWatchThreadStderr(t));
            }
            return t;
        }
        return null;
    }
}

