/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.processlauncher.cmdline.ArgValueChoice;
import tv.hd3g.processlauncher.cmdline.ParameterArg;

public class SimpleParameters {
    private static final Logger log = LoggerFactory.getLogger(SimpleParameters.class);
    private static final String LOG_ADD_PARAMETERS = "Add parameters: {}";
    private static final String PARAMS_CAN_T_TO_BE_NULL = "\"params\" can't to be null";
    private static final Character QUOTE = Character.valueOf('\"');
    private static final Character SPACE = Character.valueOf(' ');
    private final List<String> parameters;
    private String parameterKeysStartsWith = "-";
    private final Function<String, Stream<ParameterArg>> filterAndTransformParameter = p -> p.trim().chars().mapToObj(i -> Character.valueOf((char)i)).reduce(new ArrayList(), (list, chr) -> {
        if (list.isEmpty()) {
            SimpleParameters.filterMapFirstEntry(list, chr);
        } else {
            int lastPos = list.size() - 1;
            ParameterArg lastEntry = (ParameterArg)list.get(lastPos);
            if (chr.equals(QUOTE)) {
                if (lastEntry.isInQuotes()) {
                    list.add(new ParameterArg(false));
                } else {
                    if (lastEntry.isEmpty()) {
                        list.remove(lastPos);
                    }
                    list.add(new ParameterArg(true));
                }
            } else if (!chr.equals(SPACE) || lastEntry.isInQuotes()) {
                lastEntry.add(chr.charValue());
            } else if (!lastEntry.isEmpty()) {
                list.add(new ParameterArg(false));
            }
        }
        return list;
    }, (list1, list2) -> {
        ArrayList parameterArgs = new ArrayList(list1);
        parameterArgs.addAll(list2);
        return parameterArgs;
    }).stream();
    public static final List<Character> MUST_ESCAPE = List.of(Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('\"'));
    public static final List<Character> MUST_SURROUND_QUOTE = List.of(Character.valueOf(' '), Character.valueOf('+'), Character.valueOf(';'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('#'), Character.valueOf('|'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('/'), Character.valueOf('.'), Character.valueOf('<'), Character.valueOf('>'));

    SimpleParameters() {
        this.parameters = new ArrayList<String>();
    }

    SimpleParameters(String bulkParameters) {
        this();
        this.addBulkParameters(bulkParameters);
    }

    SimpleParameters(Collection<String> parameters) {
        this();
        this.addParameters(parameters);
    }

    public SimpleParameters transfertThisConfigurationTo(SimpleParameters newInstance) {
        newInstance.parameterKeysStartsWith = this.parameterKeysStartsWith;
        return this;
    }

    public SimpleParameters importParametersFrom(SimpleParameters previousInstance) {
        log.trace("Import from {}", (Object)previousInstance);
        this.parameterKeysStartsWith = previousInstance.parameterKeysStartsWith;
        this.parameters.clear();
        this.parameters.addAll(previousInstance.parameters);
        return this;
    }

    public void addAllFrom(SimpleParameters source) {
        this.parameters.addAll(source.parameters);
    }

    private static void filterMapFirstEntry(ArrayList<ParameterArg> list, Character chr) {
        if (chr.equals(QUOTE)) {
            list.add(new ParameterArg(true));
        } else if (!chr.equals(SPACE)) {
            list.add(new ParameterArg(false).add(chr.charValue()));
        }
    }

    public SimpleParameters clear() {
        log.trace("Clear all");
        this.parameters.clear();
        return this;
    }

    public boolean hasParameters(String ... params) {
        Objects.requireNonNull(params, PARAMS_CAN_T_TO_BE_NULL);
        return Arrays.stream(params).filter(Objects::nonNull).anyMatch(parameter -> this.parameters.contains(this.conformParameterKey((String)parameter)));
    }

    public SimpleParameters ifHasNotParameter(Runnable toDoIfMissing, String ... inParameters) {
        Objects.requireNonNull(toDoIfMissing, "\"toDoIfMissing\" can't to be null");
        if (!this.hasParameters(inParameters)) {
            toDoIfMissing.run();
        }
        return this;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public SimpleParameters replaceParameters(Collection<? extends String> newParameters) {
        this.parameters.clear();
        this.parameters.addAll(newParameters);
        return this;
    }

    public SimpleParameters addParameters(String ... params) {
        Objects.requireNonNull(params, PARAMS_CAN_T_TO_BE_NULL);
        this.addParameters(Arrays.stream(params).filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).toList());
        return this;
    }

    public SimpleParameters addParameters(Collection<String> params) {
        Objects.requireNonNull(params, PARAMS_CAN_T_TO_BE_NULL);
        List<String> subList = params.stream().filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).toList();
        this.parameters.addAll(subList);
        log.trace(LOG_ADD_PARAMETERS, subList);
        return this;
    }

    public SimpleParameters addBulkParameters(String params) {
        Objects.requireNonNull(params, PARAMS_CAN_T_TO_BE_NULL);
        List<String> subList = this.filterAndTransformParameter.apply(params).map(ParameterArg::toString).filter(Predicate.not(String::isEmpty)).toList();
        this.parameters.addAll(subList);
        log.trace(LOG_ADD_PARAMETERS, subList);
        return this;
    }

    public SimpleParameters prependParameters(Collection<String> params) {
        Objects.requireNonNull(params, PARAMS_CAN_T_TO_BE_NULL);
        List<String> newList = Stream.concat(params.stream().filter(Objects::nonNull), this.parameters.stream()).toList();
        this.replaceParameters(newList);
        log.trace("Prepend parameters: {}", params);
        return this;
    }

    public SimpleParameters prependParameters(String ... params) {
        Objects.requireNonNull(params, PARAMS_CAN_T_TO_BE_NULL);
        this.prependParameters(Arrays.stream(params).filter(Objects::nonNull).toList());
        return this;
    }

    public SimpleParameters prependBulkParameters(String params) {
        Objects.requireNonNull(params, PARAMS_CAN_T_TO_BE_NULL);
        this.prependParameters(this.filterAndTransformParameter.apply(params).map(ParameterArg::toString).toList());
        return this;
    }

    public String toString() {
        return this.parameters.stream().collect(Collectors.joining(" "));
    }

    public String exportToExternalCommandLine(String processExecFile) {
        return processExecFile + " " + this.parameters.stream().map(arg -> {
            String escapedChr = arg;
            for (Character chr : MUST_ESCAPE) {
                escapedChr = escapedChr.replace("" + chr, "\\" + chr);
            }
            return escapedChr;
        }).map(arg -> {
            if (MUST_SURROUND_QUOTE.stream().anyMatch(chr -> arg.indexOf(chr.charValue()) > -1)) {
                return "\"" + arg + "\"";
            }
            return arg;
        }).collect(Collectors.joining(" "));
    }

    public SimpleParameters setParametersKeysStartsWith(String parameterKeysStartsWith) {
        this.parameterKeysStartsWith = parameterKeysStartsWith;
        log.debug("Set parameters key start with: {}", (Object)parameterKeysStartsWith);
        return this;
    }

    public String getParametersKeysStartsWith() {
        return this.parameterKeysStartsWith;
    }

    boolean isParameterArgIsAParametersKey(String arg) {
        return arg.startsWith(this.parameterKeysStartsWith);
    }

    protected String conformParameterKey(String parameterKey) {
        if (!this.isParameterArgIsAParametersKey(parameterKey)) {
            return this.parameterKeysStartsWith + parameterKey;
        }
        return parameterKey;
    }

    public List<String> getValues(String parameterKey) {
        Objects.requireNonNull(parameterKey, "\"parameterKey\" can't to be null");
        String param = this.conformParameterKey(parameterKey);
        ArrayList<String> result = new ArrayList<String>();
        boolean has = false;
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String next;
            String current = this.parameters.get(pos);
            if (!current.equals(param)) continue;
            has = true;
            if (this.parameters.size() <= pos + 1 || this.isParameterArgIsAParametersKey(next = this.parameters.get(pos + 1))) continue;
            result.add(next);
        }
        if (has) {
            return Collections.unmodifiableList(result);
        }
        return null;
    }

    public boolean removeParameter(String parametersKey, int paramAsThisKeyPos) {
        Objects.requireNonNull(parametersKey, "\"parametersKey\" can't to be null");
        String param = this.conformParameterKey(parametersKey);
        int toSkip = paramAsThisKeyPos + 1;
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String next;
            String current = this.parameters.get(pos);
            if (!current.equals(param) || --toSkip != 0) continue;
            if (this.parameters.size() > pos + 1 && !this.isParameterArgIsAParametersKey(next = this.parameters.get(pos + 1))) {
                this.parameters.remove(pos + 1);
            }
            log.trace("Remove parameter: {}", (Object)this.parameters.remove(pos));
            return true;
        }
        return false;
    }

    public boolean alterParameter(String parameterKey, String newValue, int paramAsThisKeyPos) {
        Objects.requireNonNull(parameterKey, "\"parameterKey\" can't to be null");
        Objects.requireNonNull(newValue, "\"newValue\" can't to be null");
        String param = this.conformParameterKey(parameterKey);
        int toSkip = paramAsThisKeyPos + 1;
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String current = this.parameters.get(pos);
            if (!current.equals(param) || --toSkip != 0) continue;
            if (this.parameters.size() > pos + 1) {
                String next = this.parameters.get(pos + 1);
                if (!this.isParameterArgIsAParametersKey(next)) {
                    this.parameters.set(pos + 1, newValue);
                } else {
                    this.parameters.add(pos + 1, newValue);
                }
            } else {
                this.parameters.add(newValue);
            }
            log.trace("Add parameter: {}", (Object)newValue);
            return true;
        }
        return false;
    }

    public int count() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public Map<String, List<String>> getAllArgKeyValues() {
        HashMap<String, List> result = new HashMap<String, List>();
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String nextArg;
            String actualArg = this.parameters.get(pos);
            if (!this.isParameterArgIsAParametersKey(actualArg)) continue;
            List values = result.computeIfAbsent(actualArg, a -> new ArrayList());
            if (this.parameters.size() <= pos + 1 || this.isParameterArgIsAParametersKey(nextArg = this.parameters.get(pos + 1))) continue;
            values.add(nextArg);
            ++pos;
        }
        HashMap result2 = new HashMap(result.size());
        result.forEach((k, v) -> result2.put(k, Collections.unmodifiableList(v)));
        return Collections.unmodifiableMap(result2);
    }

    public void compareAndAlter(SimpleParameters toCompare, ArgValueChoice argValueChoice, boolean removeActualMissing, boolean addComparedMissing) {
        Map<String, List<String>> allCurrentArgsKeyValues = this.getAllArgKeyValues();
        Map<String, List<String>> allComparedArgsKeyValues = toCompare.getAllArgKeyValues();
        ArrayList<String> newParameters = new ArrayList<String>();
        HashSet<String> computedKeys = new HashSet<String>();
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String actualArg = this.parameters.get(pos);
            if (!this.isParameterArgIsAParametersKey(actualArg)) {
                newParameters.add(actualArg);
                continue;
            }
            List<String> selectedValues = null;
            if (!computedKeys.contains(actualArg)) {
                if (allComparedArgsKeyValues.containsKey(actualArg)) {
                    selectedValues = argValueChoice.choose(actualArg, allCurrentArgsKeyValues.get(actualArg), allComparedArgsKeyValues.get(actualArg));
                } else if (!removeActualMissing) {
                    selectedValues = allCurrentArgsKeyValues.get(actualArg);
                }
                computedKeys.add(actualArg);
            }
            if (selectedValues != null) {
                if (selectedValues.isEmpty()) {
                    newParameters.add(actualArg);
                } else {
                    selectedValues.forEach(v -> {
                        newParameters.add(actualArg);
                        newParameters.add((String)v);
                    });
                }
            }
            if (this.parameters.size() <= pos + 1 || this.isParameterArgIsAParametersKey(this.parameters.get(pos + 1))) continue;
            ++pos;
        }
        if (addComparedMissing) {
            allComparedArgsKeyValues.entrySet().stream().filter(entry -> !computedKeys.contains(entry.getKey())).forEach(entry -> {
                if (((List)entry.getValue()).isEmpty()) {
                    newParameters.add((String)entry.getKey());
                } else {
                    ((List)entry.getValue()).forEach(v -> {
                        newParameters.add((String)entry.getKey());
                        newParameters.add((String)v);
                    });
                }
            });
        }
        this.replaceParameters(newParameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameterKeysStartsWith, this.parameters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleParameters other = (SimpleParameters)obj;
        return Objects.equals(this.parameterKeysStartsWith, other.parameterKeysStartsWith) && Objects.equals(this.parameters, other.parameters);
    }
}

