/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.processlauncher.CapturedStdOutErrText;
import tv.hd3g.processlauncher.LineEntry;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class StreamParser
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamParser.class);
    static final AtomicLong CREATED_THREAD_COUNTER = new AtomicLong(-1L);
    private final InputStream processStream;
    private final boolean isStdErr;
    private final ProcesslauncherLifecycle source;
    private final List<CapturedStdOutErrText> observers;

    StreamParser(InputStream processStream, boolean isStdErr, ProcesslauncherLifecycle source, List<CapturedStdOutErrText> observers) {
        this.processStream = processStream;
        this.isStdErr = isStdErr;
        this.source = source;
        this.observers = Collections.unmodifiableList(observers);
        this.setDaemon(true);
        this.setPriority(10);
        String execName = source.getLauncher().getExecutableName();
        if (isStdErr) {
            this.setName("Executable syserr watcher for " + execName + " TId#" + CREATED_THREAD_COUNTER.incrementAndGet());
        } else {
            this.setName("Executable sysout watcher for " + execName + " TId#" + CREATED_THREAD_COUNTER.incrementAndGet());
        }
    }

    @Override
    public void run() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.processStream));
            this.subRun(reader);
        }
        catch (IOException ioe) {
            log.error("Trouble opening process streams: {}", (Object)this, (Object)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subRun(BufferedReader reader) throws IOException {
        block12: {
            try {
                String line = "";
                while ((line = reader.readLine()) != null) {
                    LineEntry lineEntry = new LineEntry(System.currentTimeMillis(), line, this.isStdErr, this.source);
                    this.observers.forEach(observer -> {
                        try {
                            observer.onText(lineEntry);
                        }
                        catch (RuntimeException e) {
                            log.error("Can't callback process text event ", (Throwable)e);
                        }
                    });
                }
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equalsIgnoreCase("Bad file descriptor")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Bad file descriptor, {}", (Object)this);
                    }
                    break block12;
                }
                if (ioe.getMessage().equalsIgnoreCase("Stream closed")) {
                    if (log.isTraceEnabled()) {
                        log.trace("Stream closed, {}", (Object)this);
                    }
                    break block12;
                }
                throw ioe;
            }
            catch (Exception e) {
                log.error("Trouble during process {}", (Object)this, (Object)e);
            }
            finally {
                reader.close();
            }
        }
    }

    public ProcesslauncherLifecycle getSource() {
        return this.source;
    }

    public boolean isStdErr() {
        return this.isStdErr;
    }
}

