/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import tv.hd3g.processlauncher.CaptureStandardOutputText;
import tv.hd3g.processlauncher.CapturedStdOutErrTextInteractive;
import tv.hd3g.processlauncher.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.CapturedStreams;
import tv.hd3g.processlauncher.DirectStandardOutputStdErrRetention;
import tv.hd3g.processlauncher.ExecutableToolRunning;
import tv.hd3g.processlauncher.InputStreamConsumer;
import tv.hd3g.processlauncher.LineEntry;
import tv.hd3g.processlauncher.ProcessLifeCycleException;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.cmdline.CommandLine;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public interface ExecutableTool {
    public Parameters getReadyToRunParameters();

    public String getExecutableName();

    default public void beforeRun(ProcesslauncherBuilder processBuilder) {
    }

    default public Consumer<ProcesslauncherBuilder> beforeExecute() {
        return p -> {};
    }

    default public Predicate<String> filterOutErrorLines() {
        return p -> true;
    }

    default public ExecutableToolRunning execute(ExecutableFinder executableFinder, Logger log, Function<LineEntry, Level> levelMapper) {
        Consumer<ProcesslauncherBuilder> execConsumerBuilder = this.beforeExecute();
        String executableName = this.getExecutableName();
        try {
            CapturedStdOutErrTextRetention textRetention;
            CommandLine cmd = new CommandLine(executableName, this.getReadyToRunParameters(), executableFinder);
            ProcesslauncherBuilder builder = new ProcesslauncherBuilder(cmd);
            if (log == null) {
                textRetention = new CapturedStdOutErrTextRetention();
                builder.getSetCaptureStandardOutputAsOutputText(CapturedStreams.BOTH_STDOUT_STDERR).addObserver(textRetention);
            } else {
                CaptureStandardOutputText capture = builder.getSetCaptureStandardOutputAsOutputText();
                capture.addObserver(new CapturedStdOutErrTextInteractive(line -> {
                    Level level = (Level)levelMapper.apply((LineEntry)line);
                    if (level != null && log.isEnabledForLevel(level)) {
                        log.atLevel(level).log(line.toString());
                    }
                    return null;
                }));
                textRetention = new CapturedStdOutErrTextRetention();
                capture.addObserver(textRetention);
            }
            if (execConsumerBuilder != null) {
                execConsumerBuilder.accept(builder);
            }
            this.beforeRun(builder);
            return new ExecutableToolRunning(textRetention, builder.start(), this);
        }
        catch (IOException e) {
            throw new ProcessLifeCycleException("Can't start " + executableName, e);
        }
    }

    default public ExecutableToolRunning execute(ExecutableFinder executableFinder) {
        return this.execute(executableFinder, null, null);
    }

    default public ProcesslauncherLifecycle execute(ExecutableFinder executableFinder, Consumer<LineEntry> stdOutErrConsumer) {
        Consumer<ProcesslauncherBuilder> execConsumerBuilder = this.beforeExecute();
        String executableName = this.getExecutableName();
        try {
            CommandLine cmd = new CommandLine(executableName, this.getReadyToRunParameters(), executableFinder);
            ProcesslauncherBuilder builder = new ProcesslauncherBuilder(cmd);
            CaptureStandardOutputText capture = builder.getSetCaptureStandardOutputAsOutputText();
            capture.addObserver(new CapturedStdOutErrTextInteractive(line -> {
                stdOutErrConsumer.accept((LineEntry)line);
                return null;
            }));
            if (execConsumerBuilder != null) {
                execConsumerBuilder.accept(builder);
            }
            this.beforeRun(builder);
            return builder.start();
        }
        catch (IOException e) {
            throw new ProcessLifeCycleException("Can't start " + executableName, e);
        }
    }

    default public ExecutableToolRunning executeDirectStdout(ExecutableFinder executableFinder, InputStreamConsumer stdOutConsumer) {
        Consumer<ProcesslauncherBuilder> execConsumerBuilder = this.beforeExecute();
        String executableName = this.getExecutableName();
        try {
            CommandLine cmd = new CommandLine(executableName, this.getReadyToRunParameters(), executableFinder);
            ProcesslauncherBuilder builder = new ProcesslauncherBuilder(cmd);
            CapturedStdOutErrTextRetention textRetention = new CapturedStdOutErrTextRetention();
            DirectStandardOutputStdErrRetention directStreams = new DirectStandardOutputStdErrRetention(textRetention, stdOutConsumer);
            builder.setCaptureStandardOutput(directStreams);
            if (execConsumerBuilder != null) {
                execConsumerBuilder.accept(builder);
            }
            this.beforeRun(builder);
            return new ExecutableToolRunning(textRetention, builder.start(), this);
        }
        catch (IOException e) {
            throw new ProcessLifeCycleException("Can't start " + executableName, e);
        }
    }
}

