/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.PrintStream;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import tv.hd3g.processlauncher.CapturedStdOutErrText;
import tv.hd3g.processlauncher.LineEntry;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class CapturedStdOutErrToPrintStream
extends CapturedStdOutErrText {
    private final PrintStream printStreamStdOut;
    private final PrintStream printStreamStdErr;
    private Optional<Predicate<LineEntry>> filter;
    static final String STDOUT_SEPARATOR = "\t> ";
    static final String STDERR_SEPARATOR = "\t! ";

    public CapturedStdOutErrToPrintStream(PrintStream printStreamStdOut, PrintStream printStreamStdErr) {
        this.printStreamStdOut = Objects.requireNonNull(printStreamStdOut, "\"printStreamStdOut\" can't to be null");
        this.printStreamStdErr = Objects.requireNonNull(printStreamStdErr, "\"printStreamStdErr\" can't to be null");
        this.filter = Optional.empty();
    }

    public Optional<Predicate<LineEntry>> getFilter() {
        return this.filter;
    }

    public CapturedStdOutErrToPrintStream setFilter(Predicate<LineEntry> filter) {
        this.filter = Optional.ofNullable(filter);
        return this;
    }

    @Override
    void onText(LineEntry lineEntry) {
        if (!this.filter.map(f -> f.test(lineEntry)).orElse(true).booleanValue()) {
            return;
        }
        PrintStream out = lineEntry.isStdErr() ? this.printStreamStdErr : this.printStreamStdOut;
        ProcesslauncherLifecycle source = lineEntry.getSource();
        out.print(source.getExecNameWithoutExt());
        out.print(source.getPID().map(pid -> "#" + pid).orElse(""));
        if (lineEntry.isStdErr()) {
            out.print(STDERR_SEPARATOR);
        } else {
            out.print(STDOUT_SEPARATOR);
        }
        out.println(lineEntry.getLine());
        out.flush();
    }
}

