/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.processlauncher.CapturedStdOutErrText;
import tv.hd3g.processlauncher.CapturedStreams;
import tv.hd3g.processlauncher.LineEntry;

public class CapturedStdOutErrTextRetention
extends CapturedStdOutErrText {
    private final CapturedStreams streamToKeep;
    private final LinkedBlockingQueue<LineEntry> lineEntries;

    public CapturedStdOutErrTextRetention(CapturedStreams streamToKeep) {
        this.streamToKeep = Objects.requireNonNull(streamToKeep, "\"streamToKeep\" can't to be null");
        this.lineEntries = new LinkedBlockingQueue();
    }

    public CapturedStdOutErrTextRetention() {
        this(CapturedStreams.BOTH_STDOUT_STDERR);
    }

    @Override
    void onText(LineEntry lineEntry) {
        if (!lineEntry.canUseThis(this.streamToKeep)) {
            return;
        }
        this.lineEntries.add(lineEntry);
    }

    public Stream<String> getStdoutLines(boolean keepEmptyLines) {
        return this.lineEntries.stream().filter(le -> {
            if (keepEmptyLines) {
                return true;
            }
            return !le.getLine().equals("");
        }).filter(le -> !le.isStdErr()).map(LineEntry::getLine);
    }

    public Stream<String> getStderrLines(boolean keepEmptyLines) {
        return this.lineEntries.stream().filter(le -> {
            if (keepEmptyLines) {
                return true;
            }
            return !le.getLine().equals("");
        }).filter(LineEntry::isStdErr).map(LineEntry::getLine);
    }

    public Stream<String> getStdouterrLines(boolean keepEmptyLines) {
        return this.lineEntries.stream().filter(le -> {
            if (keepEmptyLines) {
                return true;
            }
            return !le.getLine().equals("");
        }).map(LineEntry::getLine);
    }

    public String getStdout(boolean keepEmptyLines, String newLineSeparator) {
        return this.getStdoutLines(keepEmptyLines).collect(Collectors.joining(newLineSeparator));
    }

    public String getStderr(boolean keepEmptyLines, String newLineSeparator) {
        return this.getStderrLines(keepEmptyLines).collect(Collectors.joining(newLineSeparator));
    }

    public String getStdouterr(boolean keepEmptyLines, String newLineSeparator) {
        return this.getStdouterrLines(keepEmptyLines).collect(Collectors.joining(newLineSeparator));
    }
}

