/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.tool;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.cmdline.CommandLine;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.io.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.io.CapturedStreams;
import tv.hd3g.processlauncher.tool.ExecutableTool;
import tv.hd3g.processlauncher.tool.RunningTool;

public class ToolRunner {
    private final ExecutableFinder executableFinder;
    private final ThreadPoolExecutor executor;

    public ToolRunner(ExecutableFinder executableFinder, int maximumInParallel) {
        this.executableFinder = Objects.requireNonNull(executableFinder, "\"executableFinder\" can't to be null");
        this.executor = new ThreadPoolExecutor(1, maximumInParallel, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread t = new Thread(r);
            t.setPriority(1);
            t.setDaemon(false);
            t.setName("Executable starter");
            return t;
        });
    }

    public <T extends ExecutableTool> CompletableFuture<RunningTool<T>> execute(final T execTool) {
        Executor executorStdOutWatchers = r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("Executable sysouterr watcher for " + execTool.getExecutableName());
            t.start();
        };
        return CompletableFuture.supplyAsync(() -> {
            String executableName = execTool.getExecutableName();
            try {
                CommandLine cmd = new CommandLine(executableName, execTool.getReadyToRunParameters(), this.executableFinder);
                ProcesslauncherBuilder builder = new ProcesslauncherBuilder(cmd);
                final CapturedStdOutErrTextRetention textRetention = new CapturedStdOutErrTextRetention();
                builder.getSetCaptureStandardOutputAsOutputText(CapturedStreams.BOTH_STDOUT_STDERR, executorStdOutWatchers).getObservers().add(textRetention);
                execTool.beforeRun(builder);
                final ProcesslauncherLifecycle lifecyle = builder.start();
                class LocalRunningTool
                implements RunningTool<T> {
                    LocalRunningTool() {
                    }

                    @Override
                    public CapturedStdOutErrTextRetention getTextRetention() {
                        return textRetention;
                    }

                    @Override
                    public ProcesslauncherLifecycle getLifecyle() {
                        return lifecyle;
                    }

                    @Override
                    public T getExecutableToolSource() {
                        return execTool;
                    }
                }
                return new LocalRunningTool();
            }
            catch (IOException e) {
                throw new RuntimeException("Can't start " + executableName, e);
            }
        }, this.executor);
    }

    public ExecutableFinder getExecutableFinder() {
        return this.executableFinder;
    }
}

