/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.io;

import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.io.CapturedStreams;

public class LineEntry {
    private final long date;
    private final String line;
    private final boolean stdErr;
    private final ProcesslauncherLifecycle source;

    public LineEntry(long date, String line, boolean stdErr, ProcesslauncherLifecycle source) {
        this.line = line;
        this.stdErr = stdErr;
        this.source = source;
        this.date = date;
    }

    public long getTimeAgo() {
        return this.date - this.source.getStartDate();
    }

    public long getDate() {
        return this.date;
    }

    public String getLine() {
        return this.line;
    }

    public ProcesslauncherLifecycle getSource() {
        return this.source;
    }

    public boolean isStdErr() {
        return this.stdErr;
    }

    public boolean canUseThis(CapturedStreams choosedStream) {
        return this.stdErr && choosedStream.canCaptureStderr() || !this.stdErr && choosedStream.canCaptureStdout();
    }
}

