/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.io;

import java.io.PrintStream;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.io.CapturedStdOutErrTextObserver;
import tv.hd3g.processlauncher.io.CapturedStreams;
import tv.hd3g.processlauncher.io.LineEntry;

public class CapturedStdOutErrToPrintStream
implements CapturedStdOutErrTextObserver {
    private final PrintStream printStreamStdOut;
    private final PrintStream printStreamStdErr;
    private Optional<Predicate<LineEntry>> filter;
    static final String stdOutSeparator = "\t> ";
    static final String stdErrSeparator = "\t! ";

    public CapturedStdOutErrToPrintStream(PrintStream printStreamStdOut, PrintStream printStreamStdErr) {
        this.printStreamStdOut = Objects.requireNonNull(printStreamStdOut, "\"printStreamStdOut\" can't to be null");
        this.printStreamStdErr = Objects.requireNonNull(printStreamStdErr, "\"printStreamStdErr\" can't to be null");
        this.filter = Optional.empty();
    }

    public Optional<Predicate<LineEntry>> getFilter() {
        return this.filter;
    }

    public CapturedStdOutErrToPrintStream setFilter(Predicate<LineEntry> filter) {
        this.filter = Optional.ofNullable(filter);
        return this;
    }

    private static String getExecNameWithoutExt(ProcesslauncherLifecycle source) {
        String execName = source.getLauncher().getExecutableName();
        if (ExecutableFinder.WINDOWS_EXEC_EXTENSIONS.stream().anyMatch(ext -> execName.toLowerCase().endsWith(ext.toLowerCase()))) {
            return execName.substring(0, execName.length() - 4);
        }
        return execName;
    }

    @Override
    public void onText(LineEntry lineEntry) {
        if (!this.filter.map(f -> f.test(lineEntry)).orElse(true).booleanValue()) {
            return;
        }
        PrintStream out = lineEntry.isStdErr() ? this.printStreamStdErr : this.printStreamStdOut;
        ProcesslauncherLifecycle source = lineEntry.getSource();
        out.print(CapturedStdOutErrToPrintStream.getExecNameWithoutExt(source));
        out.print(source.getPID().map(pid -> "#" + pid).orElse(""));
        if (lineEntry.isStdErr()) {
            out.print(stdErrSeparator);
        } else {
            out.print(stdOutSeparator);
        }
        out.println(lineEntry.getLine());
        out.flush();
    }

    @Override
    public void onProcessCloseStream(ProcesslauncherLifecycle source, boolean isStdErr, CapturedStreams streamToKeepPolicy) {
        if (CapturedStreams.BOTH_STDOUT_STDERR.equals((Object)streamToKeepPolicy) && source.isCorrectlyDone()) {
            return;
        }
        PrintStream out = isStdErr ? this.printStreamStdErr : this.printStreamStdOut;
        out.print(CapturedStdOutErrToPrintStream.getExecNameWithoutExt(source));
        out.print(source.getPID().map(pid -> "#" + pid).orElse(""));
        out.print(" Ends ");
        out.print(source.getEndStatus().toString().toLowerCase());
        if (!source.isCorrectlyDone()) {
            out.print(" return ");
            out.print(source.getExitCode());
        }
        out.print(" in ");
        if (source.getUptime(TimeUnit.SECONDS) == 0L) {
            out.print(source.getCPUDuration(TimeUnit.MILLISECONDS));
            out.print(" msec.");
        } else {
            out.print(source.getUptime(TimeUnit.SECONDS));
            out.print(" sec.");
        }
        out.println();
        out.flush();
    }
}

