/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.io.CapturedStdOutErrTextObserver;
import tv.hd3g.processlauncher.io.CapturedStreams;
import tv.hd3g.processlauncher.io.LineEntry;

public class CapturedStdOutErrTextInteractive
implements CapturedStdOutErrTextObserver {
    private static Logger log = LogManager.getLogger();
    private final Function<LineEntry, String> interactive;
    private final BiConsumer<ProcesslauncherLifecycle, Boolean> onProcessClosedStream;
    private final Charset destCharset;
    private final Executor eventExecutor;

    public CapturedStdOutErrTextInteractive(Function<LineEntry, String> interactive, BiConsumer<ProcesslauncherLifecycle, Boolean> onProcessClosedStream, Charset destCharset, Executor eventExecutor) {
        this.eventExecutor = Objects.requireNonNull(eventExecutor, "\"eventExecutor\" can't to be null");
        this.interactive = Objects.requireNonNull(interactive, "\"interactive\" can't to be null");
        this.onProcessClosedStream = Objects.requireNonNull(onProcessClosedStream, "\"onProcessClosedStream\" can't to be null");
        this.destCharset = Objects.requireNonNull(destCharset, "\"destCharset\" can't to be null");
    }

    public CapturedStdOutErrTextInteractive(Function<LineEntry, String> interactive, BiConsumer<ProcesslauncherLifecycle, Boolean> onProcessClosedStream, Executor eventExecutor) {
        this(interactive, onProcessClosedStream, Charset.defaultCharset(), eventExecutor);
    }

    public CapturedStdOutErrTextInteractive(Function<LineEntry, String> interactive, BiConsumer<ProcesslauncherLifecycle, Boolean> onProcessClosedStream) {
        this(interactive, onProcessClosedStream, Charset.defaultCharset(), r -> r.run());
    }

    @Override
    public void onText(LineEntry lineEntry) {
        this.eventExecutor.execute(() -> {
            ProcesslauncherLifecycle source;
            String result = this.interactive.apply(lineEntry);
            if (result != null & (source = lineEntry.getSource()).isRunning()) {
                try {
                    source.getStdInInjection().println(result, this.destCharset);
                }
                catch (IOException e) {
                    log.error("Can't send some text to process", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void onProcessCloseStream(ProcesslauncherLifecycle source, boolean isStdErr, CapturedStreams streamToKeepPolicy) {
        this.eventExecutor.execute(() -> this.onProcessClosedStream.accept(source, isStdErr));
    }
}

