/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.io.CaptureStandardOutput;
import tv.hd3g.processlauncher.io.CapturedStdOutErrTextObserver;
import tv.hd3g.processlauncher.io.CapturedStreams;
import tv.hd3g.processlauncher.io.LineEntry;

public class CaptureStandardOutputText
implements CaptureStandardOutput {
    private static Logger log = LogManager.getLogger();
    private final CapturedStreams captureOutStreamsBehavior;
    private final List<CapturedStdOutErrTextObserver> observers;
    private final Executor executorConsumer;

    public CaptureStandardOutputText(CapturedStreams captureOutStreamsBehavior, Executor executorConsumer) {
        this.captureOutStreamsBehavior = captureOutStreamsBehavior;
        this.observers = new ArrayList<CapturedStdOutErrTextObserver>();
        this.executorConsumer = executorConsumer;
        if (executorConsumer == null) {
            throw new NullPointerException("\"executorConsumer\" can't to be null");
        }
    }

    public CaptureStandardOutputText(Executor executorConsumer) {
        this(CapturedStreams.BOTH_STDOUT_STDERR, executorConsumer);
    }

    public synchronized List<CapturedStdOutErrTextObserver> getObservers() {
        return this.observers;
    }

    @Override
    public void stdOutStreamConsumer(InputStream processInputStream, ProcesslauncherLifecycle source) {
        if (this.captureOutStreamsBehavior.canCaptureStdout()) {
            this.parseStream(processInputStream, false, source);
        }
    }

    @Override
    public void stdErrStreamConsumer(InputStream processInputStream, ProcesslauncherLifecycle source) {
        if (this.captureOutStreamsBehavior.canCaptureStderr()) {
            this.parseStream(processInputStream, true, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseStream(InputStream processStream, boolean isStdErr, ProcesslauncherLifecycle source) {
        List<CapturedStdOutErrTextObserver> finalObservers;
        CaptureStandardOutputText captureStandardOutputText = this;
        synchronized (captureStandardOutputText) {
            finalObservers = Collections.unmodifiableList(new ArrayList<CapturedStdOutErrTextObserver>(this.observers));
        }
        this.executorConsumer.execute(() -> {
            block17: {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(processStream));){
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        LineEntry lineEntry = new LineEntry(System.currentTimeMillis(), line, isStdErr, source);
                        finalObservers.forEach(observer -> {
                            try {
                                observer.onText(lineEntry);
                            }
                            catch (RuntimeException e) {
                                log.error("Can't callback process text event ", (Throwable)e);
                            }
                        });
                    }
                }
                catch (IOException ioe) {
                    log.error("Trouble opening process streams: " + this.toString(), (Throwable)ioe);
                }
                finally {
                    finalObservers.forEach(observer -> observer.onProcessCloseStream(source, isStdErr, this.captureOutStreamsBehavior));
                }
            }
        });
    }
}

