/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import tv.hd3g.processlauncher.cmdline.ParameterArg;

class SimpleParameters {
    private static Logger log = LogManager.getLogger();
    private static final Character QUOTE = Character.valueOf('\"');
    private static final Character SPACE = Character.valueOf(' ');
    private final List<String> parameters;
    private String parameterKeysStartsWith = "-";
    private final Function<String, Stream<ParameterArg>> filterAnTransformParameter = p -> p.trim().chars().mapToObj(i -> Character.valueOf((char)i)).reduce(new ArrayList(), (list, chr) -> {
        if (list.isEmpty()) {
            if (chr == QUOTE) {
                list.add(new ParameterArg(true));
            } else if (chr != SPACE) {
                list.add(new ParameterArg(false).add(chr.charValue()));
            }
        } else {
            int lastPos = list.size() - 1;
            ParameterArg lastEntry = (ParameterArg)list.get(lastPos);
            if (chr == QUOTE) {
                if (lastEntry.isInQuotes()) {
                    list.add(new ParameterArg(false));
                } else {
                    if (lastEntry.isEmpty()) {
                        list.remove(lastPos);
                    }
                    list.add(new ParameterArg(true));
                }
            } else if (chr == SPACE) {
                if (lastEntry.isInQuotes()) {
                    lastEntry.add(chr.charValue());
                } else if (!lastEntry.isEmpty()) {
                    list.add(new ParameterArg(false));
                }
            } else {
                lastEntry.add(chr.charValue());
            }
        }
        return list;
    }, (list1, list2) -> {
        ArrayList ParameterArgs = new ArrayList(list1);
        ParameterArgs.addAll(list2);
        return ParameterArgs;
    }).stream();

    SimpleParameters() {
        this.parameters = new ArrayList<String>();
    }

    SimpleParameters(String bulkParameters) {
        this();
        this.addBulkParameters(bulkParameters);
    }

    SimpleParameters(Collection<String> parameters) {
        this();
        this.addParameters(parameters);
    }

    public SimpleParameters transfertThisConfigurationTo(SimpleParameters newInstance) {
        newInstance.parameterKeysStartsWith = this.parameterKeysStartsWith;
        return this;
    }

    public SimpleParameters importParametersFrom(SimpleParameters previousInstance) {
        log.trace("Import from {}", new Supplier[]{() -> previousInstance});
        this.parameterKeysStartsWith = previousInstance.parameterKeysStartsWith;
        this.parameters.clear();
        this.parameters.addAll(previousInstance.parameters);
        return this;
    }

    public void addAllFrom(SimpleParameters source) {
        this.parameters.addAll(source.parameters);
    }

    public SimpleParameters clear() {
        log.trace("Clear all");
        this.parameters.clear();
        return this;
    }

    public boolean hasParameters(String ... params) {
        Objects.requireNonNull(params, "\"params\" can't to be null");
        return Arrays.stream(params).filter(p -> p != null).anyMatch(parameter -> {
            String param = this.conformParameterKey((String)parameter);
            return this.parameters.contains(param);
        });
    }

    public SimpleParameters ifHasNotParameter(Runnable toDoIfMissing, String ... inParameters) {
        Objects.requireNonNull(toDoIfMissing, "\"toDoIfMissing\" can't to be null");
        if (!this.hasParameters(inParameters)) {
            toDoIfMissing.run();
        }
        return this;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public SimpleParameters replaceParameters(Collection<? extends String> newParameters) {
        this.parameters.clear();
        this.parameters.addAll(newParameters);
        return this;
    }

    public SimpleParameters addParameters(String ... params) {
        Objects.requireNonNull(params, "\"params\" can't to be null");
        this.parameters.addAll(Arrays.stream(params).filter(p -> p != null).collect(Collectors.toUnmodifiableList()));
        log.trace("Add parameters: {}", new Supplier[]{() -> Arrays.stream(params).collect(Collectors.toUnmodifiableList())});
        return this;
    }

    public SimpleParameters addParameters(Collection<String> params) {
        Objects.requireNonNull(params, "\"params\" can't to be null");
        this.parameters.addAll(params.stream().filter(p -> p != null).collect(Collectors.toUnmodifiableList()));
        log.trace("Add parameters: {}", new Supplier[]{() -> params});
        return this;
    }

    public SimpleParameters addBulkParameters(String params) {
        Objects.requireNonNull(params, "\"params\" can't to be null");
        this.parameters.addAll(this.filterAnTransformParameter.apply(params).map(ParameterArg2 -> ParameterArg2.toString()).collect(Collectors.toUnmodifiableList()));
        log.trace("Add parameters: {}", (Object)params);
        return this;
    }

    public SimpleParameters prependParameters(Collection<String> params) {
        Objects.requireNonNull(params, "\"params\" can't to be null");
        List newList = Stream.concat(params.stream().filter(p -> p != null), this.parameters.stream()).collect(Collectors.toUnmodifiableList());
        this.replaceParameters(newList);
        log.trace("Prepend parameters: {}", new Supplier[]{() -> params});
        return this;
    }

    public SimpleParameters prependParameters(String ... params) {
        Objects.requireNonNull(params, "\"params\" can't to be null");
        this.prependParameters(Arrays.stream(params).filter(p -> p != null).collect(Collectors.toUnmodifiableList()));
        return this;
    }

    public SimpleParameters prependBulkParameters(String params) {
        Objects.requireNonNull(params, "\"params\" can't to be null");
        this.prependParameters(this.filterAnTransformParameter.apply(params).map(ParameterArg2 -> ParameterArg2.toString()).collect(Collectors.toUnmodifiableList()));
        return this;
    }

    public String toString() {
        return this.parameters.stream().collect(Collectors.joining(" "));
    }

    public SimpleParameters setParametersKeysStartsWith(String parameterKeysStartsWith) {
        this.parameterKeysStartsWith = parameterKeysStartsWith;
        log.debug("Set parameters key start with: {}", (Object)parameterKeysStartsWith);
        return this;
    }

    public String getParametersKeysStartsWith() {
        return this.parameterKeysStartsWith;
    }

    boolean isParameterArgIsAParametersKey(String arg) {
        return arg.startsWith(this.parameterKeysStartsWith);
    }

    protected String conformParameterKey(String parameterKey) {
        if (!this.isParameterArgIsAParametersKey(parameterKey)) {
            return this.parameterKeysStartsWith + parameterKey;
        }
        return parameterKey;
    }

    public List<String> getValues(String parameterKey) {
        Objects.requireNonNull(parameterKey, "\"parameterKey\" can't to be null");
        String param = this.conformParameterKey(parameterKey);
        ArrayList<String> result = new ArrayList<String>();
        boolean has = false;
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String next;
            String current = this.parameters.get(pos);
            if (!current.equals(param)) continue;
            has = true;
            if (this.parameters.size() <= pos + 1 || this.isParameterArgIsAParametersKey(next = this.parameters.get(pos + 1))) continue;
            result.add(next);
        }
        if (has) {
            return Collections.unmodifiableList(result);
        }
        return null;
    }

    public boolean removeParameter(String parametersKey, int paramAsThisKeyPos) {
        Objects.requireNonNull(parametersKey, "\"parametersKey\" can't to be null");
        String param = this.conformParameterKey(parametersKey);
        int toSkip = paramAsThisKeyPos + 1;
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String next;
            String current = this.parameters.get(pos);
            if (!current.equals(param) || --toSkip != 0) continue;
            if (this.parameters.size() > pos + 1 && !this.isParameterArgIsAParametersKey(next = this.parameters.get(pos + 1))) {
                this.parameters.remove(pos + 1);
            }
            log.trace("Remove parameter: {}", (Object)this.parameters.remove(pos));
            return true;
        }
        return false;
    }

    public boolean alterParameter(String parameterKey, String newValue, int paramAsThisKeyPos) {
        Objects.requireNonNull(parameterKey, "\"parameterKey\" can't to be null");
        Objects.requireNonNull(newValue, "\"newValue\" can't to be null");
        String param = this.conformParameterKey(parameterKey);
        int toSkip = paramAsThisKeyPos + 1;
        for (int pos = 0; pos < this.parameters.size(); ++pos) {
            String current = this.parameters.get(pos);
            if (!current.equals(param) || --toSkip != 0) continue;
            if (this.parameters.size() > pos + 1) {
                String next = this.parameters.get(pos + 1);
                if (!this.isParameterArgIsAParametersKey(next)) {
                    this.parameters.set(pos + 1, newValue);
                } else {
                    this.parameters.add(pos + 1, newValue);
                }
            } else {
                this.parameters.add(newValue);
            }
            log.trace("Add parameter: {}", (Object)newValue);
            return true;
        }
        return false;
    }
}

