/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.cmdline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.processlauncher.cmdline.SimpleParameters;

public class Parameters
extends SimpleParameters {
    private static final BinaryOperator<List<String>> LIST_COMBINER = (list1, list2) -> Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toUnmodifiableList());
    private String startVarTag;
    private String endVarTag;

    public Parameters() {
        this.setVarTags("<%", "%>");
    }

    public Parameters(String bulkParameters) {
        super(bulkParameters);
        this.setVarTags("<%", "%>");
    }

    public Parameters(String ... bulkParameters) {
        this.setVarTags("<%", "%>");
        Objects.requireNonNull(bulkParameters, "\"bulkParameters\" can't to be null");
        Arrays.stream(bulkParameters).filter(p -> p != null).forEach(bulkParameter -> super.addBulkParameters((String)bulkParameter));
    }

    public Parameters(Collection<String> parameters) {
        super(parameters);
        this.setVarTags("<%", "%>");
    }

    public Parameters setVarTags(String startVarTag, String endVarTag) {
        this.startVarTag = Objects.requireNonNull(startVarTag, "\"startVarTag\" can't to be null");
        if (startVarTag.isEmpty()) {
            throw new NullPointerException("\"startVarTag\" can't to be empty");
        }
        this.endVarTag = Objects.requireNonNull(endVarTag, "\"endVarTag\" can't to be null");
        if (endVarTag.isEmpty()) {
            throw new NullPointerException("\"endVarTag\" can't to be empty");
        }
        return this;
    }

    public String getEndVarTag() {
        return this.endVarTag;
    }

    public String getStartVarTag() {
        return this.startVarTag;
    }

    public boolean isTaggedParameter(String param) {
        Objects.requireNonNull(param, "\"param\" can't to be null");
        if (param.isEmpty()) {
            return false;
        }
        if (param.contains(" ")) {
            return false;
        }
        return param.startsWith(this.startVarTag) & param.endsWith(this.endVarTag);
    }

    public String extractVarNameFromTaggedParameter(String param) {
        if (!this.isTaggedParameter(param)) {
            return null;
        }
        if (param.length() == this.startVarTag.length() + this.endVarTag.length()) {
            return null;
        }
        return param.substring(this.startVarTag.length(), param.length() - this.endVarTag.length());
    }

    public String addVariable(String varName) {
        this.addParameters(new String[]{this.startVarTag + varName + this.endVarTag});
        return varName;
    }

    public Parameters clone() {
        Parameters newInstance = new Parameters(this.startVarTag, this.endVarTag);
        newInstance.importParametersFrom(this);
        return newInstance;
    }

    public boolean injectParamsAroundVariable(String varName, Collection<String> addBefore, Collection<String> addAfter) {
        Objects.requireNonNull(varName, "\"varName\" can't to be null");
        Objects.requireNonNull(addBefore, "\"addBefore\" can't to be null");
        Objects.requireNonNull(addAfter, "\"addAfter\" can't to be null");
        AtomicBoolean isDone = new AtomicBoolean(false);
        List<String> newParameters = this.getParameters().stream().reduce(Collections.unmodifiableList(new ArrayList()), (list, arg) -> {
            String currentVarName;
            if (this.isTaggedParameter((String)arg) && (currentVarName = this.extractVarNameFromTaggedParameter((String)arg)).equals(varName)) {
                isDone.set(true);
                return Stream.concat(list.stream(), Stream.concat(Stream.concat(addBefore.stream(), Stream.of(arg)), addAfter.stream())).collect(Collectors.toUnmodifiableList());
            }
            return Stream.concat(list.stream(), Stream.of(arg)).collect(Collectors.toUnmodifiableList());
        }, LIST_COMBINER);
        this.replaceParameters(newParameters);
        return isDone.get();
    }

    public Parameters removeVariables(boolean removeParamsIfNoVarToInject) {
        return this.injectVariables(Collections.emptyMap(), removeParamsIfNoVarToInject);
    }

    public Parameters injectVariables(Map<String, String> varsToInject, boolean removeParamsIfNoVarToInject) {
        List<Object> newParameters = removeParamsIfNoVarToInject ? this.getParameters().stream().reduce(Collections.unmodifiableList(new ArrayList()), (list, arg) -> {
            if (this.isTaggedParameter((String)arg)) {
                String varName = this.extractVarNameFromTaggedParameter((String)arg);
                if (varsToInject.containsKey(varName)) {
                    return Stream.concat(list.stream(), Stream.of((String)varsToInject.get(varName))).collect(Collectors.toUnmodifiableList());
                }
                if (list.isEmpty()) {
                    return list;
                }
                if (this.isParameterArgIsAParametersKey((String)list.get(list.size() - 1))) {
                    return list.stream().limit(list.size() - 1).collect(Collectors.toUnmodifiableList());
                }
                return list;
            }
            return Stream.concat(list.stream(), Stream.of(arg)).collect(Collectors.toUnmodifiableList());
        }, LIST_COMBINER) : this.getParameters().stream().map(arg -> {
            String varName = this.extractVarNameFromTaggedParameter((String)arg);
            if (varName != null) {
                return (String)varsToInject.get(varName);
            }
            return arg;
        }).filter(arg -> arg != null).collect(Collectors.toUnmodifiableList());
        this.replaceParameters(newParameters);
        return this;
    }
}

