/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.cmdline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutableFinder {
    private static final Logger log = LogManager.getLogger();
    public static final Predicate<File> isValidDirectory = f -> f.exists() && f.isDirectory() && f.canRead();
    public static final List<String> WINDOWS_EXEC_EXTENSIONS;
    public static final List<File> GLOBAL_DECLARED_DIRS;
    private final LinkedList<File> paths;
    private final LinkedHashMap<String, File> declaredInConfiguration = new LinkedHashMap();
    private final boolean isWindowsStylePath = File.separator.equals("\\");

    public ExecutableFinder() {
        this.paths = new LinkedList<File>(GLOBAL_DECLARED_DIRS);
        this.addLocalPath("/bin");
        this.addLocalPath("/App/bin");
        this.paths.add(new File(System.getProperty("user.dir")));
        this.paths.addAll(Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(p -> new File((String)p)).filter(isValidDirectory).collect(Collectors.toUnmodifiableList()));
        this.paths.addAll(Arrays.stream(System.getenv("PATH").split(File.pathSeparator)).map(p -> new File((String)p)).filter(isValidDirectory).collect(Collectors.toUnmodifiableList()));
        List newList = this.paths.stream().distinct().collect(Collectors.toUnmodifiableList());
        this.paths.clear();
        this.paths.addAll(newList);
        if (log.isTraceEnabled()) {
            log.trace("Full path: " + this.paths.stream().map(f -> f.getPath()).collect(Collectors.joining(File.pathSeparator)));
        }
    }

    public String getFullPathToString() {
        return this.paths.stream().map(f -> f.getPath()).reduce((left, right) -> left + File.pathSeparator + right).get();
    }

    public List<File> getFullPath() {
        return Collections.unmodifiableList(this.paths);
    }

    public ExecutableFinder addLocalPath(String relativeUserHomePath) {
        if (this.isWindowsStylePath) {
            relativeUserHomePath.replaceAll("/", "\\\\");
        } else {
            relativeUserHomePath.replaceAll("\\\\", "/");
        }
        String userHome = System.getProperty("user.home");
        File f = new File(userHome + File.separator + relativeUserHomePath).getAbsoluteFile();
        return this.addPath(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableFinder addPath(File filePath) {
        File f = filePath.getAbsoluteFile();
        if (isValidDirectory.test(f)) {
            ExecutableFinder executableFinder = this;
            synchronized (executableFinder) {
                log.debug("Register path: " + f.getPath());
                this.paths.addFirst(f);
            }
        }
        return this;
    }

    private boolean validExec(File exec) {
        if (!exec.exists()) {
            return false;
        }
        if (!exec.isFile()) {
            return false;
        }
        if (!exec.canRead()) {
            return false;
        }
        return exec.canExecute();
    }

    public ExecutableFinder registerExecutable(String name, File fullPath) throws IOException {
        if (!this.validExec(fullPath)) {
            throw new IOException("Invalid declaredInConfiguration executable: " + name + " can't be correctly found in " + fullPath);
        }
        this.declaredInConfiguration.put(name, fullPath);
        return this;
    }

    public File get(String name) throws FileNotFoundException {
        if (this.declaredInConfiguration.containsKey(name)) {
            return this.declaredInConfiguration.get(name);
        }
        File exec = new File(name);
        if (this.validExec(exec)) {
            return exec;
        }
        List allFileCandidates = Stream.concat(this.declaredInConfiguration.values().stream().map(file -> file.getParentFile()), this.paths.stream()).map(dir -> new File(dir + File.separator + name).getAbsoluteFile()).distinct().collect(Collectors.toUnmodifiableList());
        if (!this.isWindowsStylePath) {
            return allFileCandidates.stream().filter(file -> this.validExec((File)file)).findFirst().orElseThrow(() -> new FileNotFoundException("Can't found executable \"" + name + "\""));
        }
        return (File)allFileCandidates.stream().flatMap(file -> {
            boolean hasAlreadyValidExt = WINDOWS_EXEC_EXTENSIONS.stream().anyMatch(ext -> file.getName().toLowerCase().endsWith("." + ext.toLowerCase()));
            if (hasAlreadyValidExt) {
                if (this.validExec((File)file)) {
                    return Stream.of(file);
                }
                return Stream.empty();
            }
            return WINDOWS_EXEC_EXTENSIONS.stream().flatMap(ext -> Stream.of(new File(file + "." + ext.toLowerCase()), new File(file + "." + ext.toUpperCase()))).filter(fileExt -> this.validExec((File)fileExt));
        }).findFirst().orElseThrow(() -> new FileNotFoundException("Can't found executable \"" + name + "\""));
    }

    static {
        if (System.getenv().containsKey("PATHEXT")) {
            String pathExt = System.getenv("PATHEXT");
            if (pathExt.indexOf(";") > 0) {
                WINDOWS_EXEC_EXTENSIONS = Collections.unmodifiableList(Arrays.stream(pathExt.split(";")).map(ext -> ext.toLowerCase().substring(1)).collect(Collectors.toUnmodifiableList()));
            } else {
                log.warn("Invalid PATHEXT env.: " + pathExt);
                WINDOWS_EXEC_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("exe", "com", "cmd", "bat"));
            }
        } else {
            WINDOWS_EXEC_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("exe", "com", "cmd", "bat"));
        }
        if (!System.getProperty("execfinder.searchdir", "").equals("")) {
            GLOBAL_DECLARED_DIRS = Collections.unmodifiableList(Arrays.stream(System.getProperty("execfinder.searchdir").split(File.pathSeparator)).map(File::new).filter(isValidDirectory).map(File::getAbsoluteFile).collect(Collectors.toList()));
            log.debug("Specific executable path declared via system property: " + GLOBAL_DECLARED_DIRS.stream().map(File::getPath).collect(Collectors.joining(", ")));
        } else {
            GLOBAL_DECLARED_DIRS = Collections.emptyList();
        }
    }
}

