/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher.cmdline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public class CommandLine {
    private final File executable;
    private final ExecutableFinder executableFinder;
    private final Parameters parameters;

    public CommandLine(File executable, Parameters parameters) throws IOException {
        this.executable = executable;
        if (!executable.isFile() | !executable.exists()) {
            throw new FileNotFoundException("Can't found " + executable);
        }
        if (!executable.canExecute()) {
            throw new IOException("Can't execute " + executable);
        }
        this.executableFinder = null;
        this.parameters = Objects.requireNonNull(parameters, "\"parameters\" can't to be null").clone();
    }

    public CommandLine(String execName, Parameters parameters, ExecutableFinder executableFinder) throws IOException {
        Objects.requireNonNull(execName, "\"execName\" can't to be null");
        this.executableFinder = executableFinder;
        if (executableFinder != null) {
            this.executable = executableFinder.get(execName);
        } else {
            this.executable = new File(execName);
            if (!this.executable.isFile() | !this.executable.exists()) {
                throw new FileNotFoundException("Can't found " + this.executable);
            }
            if (!this.executable.canExecute()) {
                throw new IOException("Can't execute " + this.executable);
            }
        }
        this.parameters = Objects.requireNonNull(parameters, "\"parameters\" can't to be null").clone();
    }

    public CommandLine(File executable, String parameters) throws IOException {
        this(executable, new Parameters(Objects.requireNonNull(parameters, "\"parameters\" can't to be null")));
    }

    public CommandLine(String execName, String parameters, ExecutableFinder executableFinder) throws IOException {
        this(execName, new Parameters(Objects.requireNonNull(parameters, "\"parameters\" can't to be null")), executableFinder);
    }

    public String toString() {
        return this.executable.getPath() + " " + this.parameters.toString();
    }

    String getParametersToString() {
        return this.parameters.toString();
    }

    public Optional<ExecutableFinder> getExecutableFinder() {
        return Optional.ofNullable(this.executableFinder);
    }

    public File getExecutable() {
        return this.executable;
    }

    public Parameters getParameters() {
        return this.parameters;
    }
}

