/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.util.Optional;
import tv.hd3g.processlauncher.EndStatus;

public interface ProcesslauncherLifecycleShortcutTraits {
    public Process getProcess();

    public EndStatus getEndStatus();

    default public boolean isCorrectlyDone() {
        return this.getEndStatus().equals((Object)EndStatus.CORRECTLY_DONE);
    }

    default public Integer getExitCode() {
        while (this.getProcess().isAlive()) {
            Thread.onSpinWait();
        }
        while (true) {
            try {
                return this.getProcess().exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (!e.getMessage().equalsIgnoreCase("process has not exited")) {
                    throw e;
                }
                Thread.onSpinWait();
                continue;
            }
            break;
        }
    }

    default public Optional<String> getUserExec() {
        return this.getProcess().info().user();
    }

    default public Optional<Long> getPID() {
        try {
            return Optional.of(this.getProcess().pid());
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    default public Boolean isRunning() {
        return this.getProcess().isAlive();
    }
}

