/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tv.hd3g.processlauncher.EndStatus;
import tv.hd3g.processlauncher.ExecutionCallbacker;
import tv.hd3g.processlauncher.ExternalProcessStartup;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.Processlauncher;
import tv.hd3g.processlauncher.ProcesslauncherLifecycleShortcutTraits;
import tv.hd3g.processlauncher.io.StdInInjection;

public class ProcesslauncherLifecycle
implements ProcesslauncherLifecycleShortcutTraits {
    private static Logger log = LogManager.getLogger();
    private final Processlauncher launcher;
    private final Process process;
    private final Thread shutdownHook;
    private final String fullCommandLine;
    private final long startDate;
    private volatile boolean processWasKilled;
    private volatile boolean processWasStoppedBecauseTooLongTime;
    private volatile long endDate;
    private StdInInjection stdInInjection;

    ProcesslauncherLifecycle(Processlauncher launcher) throws IOException {
        this.launcher = launcher;
        this.processWasKilled = false;
        this.processWasStoppedBecauseTooLongTime = false;
        this.fullCommandLine = launcher.getFullCommandLine();
        ProcessBuilder pBuilder = launcher.getProcessBuilder();
        Optional<ExternalProcessStartup> externalProcessStartup = launcher.getExternalProcessStartup();
        if (externalProcessStartup.isPresent()) {
            this.process = externalProcessStartup.get().startProcess(pBuilder);
            Objects.requireNonNull(this.process, "Can't manage null process");
        } else {
            this.process = pBuilder.start();
            log.info("Start process #" + this.process.pid() + " " + this.fullCommandLine);
        }
        this.startDate = System.currentTimeMillis();
        this.shutdownHook = new Thread(() -> {
            log.warn("Try to kill " + this.toString());
            this.killProcessTree(this.process);
        });
        this.shutdownHook.setDaemon(false);
        this.shutdownHook.setPriority(10);
        this.shutdownHook.setName("ShutdownHook for " + this.toString());
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        launcher.getExecutionTimeLimiter().ifPresent(etl -> etl.addTimesUp(this, this.process));
        List<ExecutionCallbacker> executionCallbackers = launcher.getExecutionCallbackers();
        executionCallbackers.forEach(ec -> ec.postStartupExecution(this));
        launcher.getCaptureStandardOutput().ifPresent(cso -> {
            cso.stdOutStreamConsumer(this.process.getInputStream(), this);
            cso.stdErrStreamConsumer(this.process.getErrorStream(), this);
        });
        this.process.onExit().thenRun(() -> {
            this.endDate = System.currentTimeMillis();
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            externalProcessStartup.ifPresent(eps -> eps.onEndProcess(this));
            executionCallbackers.forEach(ec -> ec.onEndExecution(this));
        });
    }

    public long getStartDate() {
        return this.getProcess().info().startInstant().flatMap(i -> Optional.of(i.toEpochMilli())).orElse(this.startDate);
    }

    public String toString() {
        if (this.process.isAlive()) {
            return "Process" + this.getPID().map(pid -> " #" + pid).orElse("") + " " + this.fullCommandLine + " ; since " + this.getUptime(TimeUnit.SECONDS) + " sec";
        }
        return "Exec " + this.getEndStatus() + " " + this.fullCommandLine;
    }

    private static String processHandleToString(ProcessHandle processHandle, boolean verbose) {
        if (verbose) {
            return processHandle.info().command().orElse("<?>") + " #" + processHandle.pid() + " by " + processHandle.info().user().orElse("<?>") + " since " + processHandle.info().totalCpuDuration().orElse(Duration.ZERO).getSeconds() + " sec";
        }
        return processHandle.info().commandLine().orElse("<?>") + " #" + processHandle.pid();
    }

    private void killProcessTree(Process process) {
        if (!process.isAlive()) {
            return;
        }
        log.debug("Internal kill " + this.toString());
        List<ProcessHandle> cantKill = process.descendants().filter(processHandle -> processHandle.isAlive()).filter(processHandle -> {
            if (log.isDebugEnabled()) {
                log.info("Close manually process " + ProcesslauncherLifecycle.processHandleToString(processHandle, true));
            } else if (log.isInfoEnabled()) {
                log.info("Close manually process " + ProcesslauncherLifecycle.processHandleToString(processHandle, false));
            }
            return !processHandle.destroy();
        }).filter(processHandle -> {
            if (log.isDebugEnabled()) {
                log.info("Force to close process " + ProcesslauncherLifecycle.processHandleToString(processHandle, true));
            } else if (log.isInfoEnabled()) {
                log.info("Force to close process " + ProcesslauncherLifecycle.processHandleToString(processHandle, false));
            }
            return !processHandle.destroyForcibly();
        }).collect(Collectors.toUnmodifiableList());
        if (process.isAlive()) {
            log.info("Close manually process " + ProcesslauncherLifecycle.processHandleToString(process.toHandle(), true));
            if (!process.toHandle().destroy()) {
                log.info("Force to close process " + ProcesslauncherLifecycle.processHandleToString(process.toHandle(), true));
                if (!process.toHandle().destroyForcibly()) {
                    throw new RuntimeException("Can't close process " + ProcesslauncherLifecycle.processHandleToString(process.toHandle(), true));
                }
            }
        }
        if (!cantKill.isEmpty()) {
            cantKill.forEach(processHandle -> log.error("Can't force close process " + ProcesslauncherLifecycle.processHandleToString(processHandle, true)));
            throw new RuntimeException("Can't close process " + this.toString() + " for PID " + cantKill.stream().map(p -> p.pid()).map(pid -> String.valueOf(pid)).collect(Collectors.joining(", ")));
        }
    }

    public Processlauncher getLauncher() {
        return this.launcher;
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public EndStatus getEndStatus() {
        if (this.process.isAlive()) {
            return EndStatus.NOT_YET_DONE;
        }
        if (this.processWasKilled) {
            return EndStatus.KILLED;
        }
        if (this.processWasStoppedBecauseTooLongTime) {
            return EndStatus.TOO_LONG_EXECUTION_TIME;
        }
        if (this.launcher.isExecCodeMustBeZero() && this.process.exitValue() != 0) {
            return EndStatus.DONE_WITH_ERROR;
        }
        return EndStatus.CORRECTLY_DONE;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public long getUptime(TimeUnit unit) {
        if (this.endDate > 0L) {
            return unit.convert(this.endDate - this.getStartDate(), TimeUnit.MILLISECONDS);
        }
        return unit.convert(System.currentTimeMillis() - this.getStartDate(), TimeUnit.MILLISECONDS);
    }

    public long getCPUDuration(TimeUnit unit) {
        return unit.convert(this.process.info().totalCpuDuration().orElse(Duration.ZERO).toMillis(), TimeUnit.MILLISECONDS);
    }

    public boolean isKilled() {
        return this.processWasKilled;
    }

    public boolean isTooLongTime() {
        return this.processWasStoppedBecauseTooLongTime;
    }

    ProcesslauncherLifecycle runningTakesTooLongTimeStopIt() {
        this.processWasStoppedBecauseTooLongTime = true;
        this.killProcessTree(this.process);
        return this;
    }

    public ProcesslauncherLifecycle kill() {
        if (!this.process.isAlive()) {
            return this;
        }
        this.processWasKilled = true;
        this.killProcessTree(this.process);
        return this;
    }

    public ProcesslauncherLifecycle waitForEnd() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Can't wait the end of " + this.fullCommandLine, e);
        }
        return this;
    }

    public ProcesslauncherLifecycle waitForEnd(long timeout, TimeUnit unit) {
        try {
            this.process.waitFor(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Can't wait the end of " + this.fullCommandLine, e);
        }
        return this;
    }

    public ProcesslauncherLifecycle checkExecution() {
        this.waitForEnd();
        if (!this.isCorrectlyDone()) {
            throw new InvalidExecution(this);
        }
        return this;
    }

    public synchronized StdInInjection getStdInInjection() {
        if (this.stdInInjection == null) {
            this.stdInInjection = new StdInInjection(this.process.getOutputStream());
        }
        return this.stdInInjection;
    }

    String getFullCommandLine() {
        return this.fullCommandLine;
    }
}

