/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import tv.hd3g.processlauncher.ExecutionCallbacker;
import tv.hd3g.processlauncher.ExecutionTimeLimiter;
import tv.hd3g.processlauncher.ExternalProcessStartup;
import tv.hd3g.processlauncher.Processlauncher;
import tv.hd3g.processlauncher.ProcesslauncherBuilderShortcutTraits;
import tv.hd3g.processlauncher.cmdline.CommandLine;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.io.CaptureStandardOutput;

public class ProcesslauncherBuilder
implements ProcesslauncherBuilderShortcutTraits {
    private final File executable;
    private final List<String> parameters;
    private final LinkedHashMap<String, String> environment;
    private File workingDirectory;
    private boolean execCodeMustBeZero;
    private final List<ExecutionCallbacker> executionCallbackers;
    private Optional<ExecutionTimeLimiter> executionTimeLimiter;
    private Optional<CaptureStandardOutput> captureStandardOutput;
    private Optional<ExternalProcessStartup> externalProcessStartup;
    static final Function<String, String> addQuotesIfSpaces = s -> {
        if (s.contains(" ")) {
            return "\"" + s + "\"";
        }
        return s;
    };

    public ProcesslauncherBuilder(File executable, Collection<String> parameters, ExecutableFinder execFinder) {
        this.executable = Objects.requireNonNull(executable, "\"executable\" can't to be null");
        this.parameters = Collections.unmodifiableList(new ArrayList<String>(Objects.requireNonNull(parameters, "\"parameters\" can't to be null")));
        this.environment = new LinkedHashMap();
        this.environment.putAll(System.getenv());
        if (!this.environment.containsKey("LANG")) {
            this.environment.put("LANG", Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + "." + Charset.forName("UTF-8"));
        }
        if (execFinder != null) {
            this.environment.put("PATH", execFinder.getFullPathToString());
        } else {
            this.environment.put("PATH", System.getenv("PATH"));
        }
        this.execCodeMustBeZero = true;
        this.executionCallbackers = new ArrayList<ExecutionCallbacker>();
        this.executionTimeLimiter = Optional.empty();
        this.captureStandardOutput = Optional.empty();
        this.externalProcessStartup = Optional.empty();
    }

    public ProcesslauncherBuilder(File executable, Collection<String> parameters) {
        this(executable, parameters, null);
    }

    public ProcesslauncherBuilder(CommandLine commandLine) {
        this(commandLine.getExecutable(), commandLine.getParameters().getParameters(), commandLine.getExecutableFinder().orElseGet(() -> new ExecutableFinder()));
    }

    public String getEnvironmentVar(String key) {
        return this.environment.get(key);
    }

    public ProcesslauncherBuilder setEnvironmentVar(String key, String value) {
        if (key.equalsIgnoreCase("path") && System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            this.environment.put("PATH", value);
            this.environment.put("Path", value);
        } else {
            this.environment.put(key, value);
        }
        return this;
    }

    public ProcesslauncherBuilder setEnvironmentVarIfNotFound(String key, String value) {
        if (this.environment.containsKey(key)) {
            return this;
        }
        return this.setEnvironmentVar(key, value);
    }

    public void forEachEnvironmentVar(BiConsumer<String, String> action) {
        this.environment.forEach(action);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ProcesslauncherBuilder setWorkingDirectory(File workingDirectory) throws IOException {
        Objects.requireNonNull(workingDirectory, "\"workingDirectory\" can't to be null");
        if (!workingDirectory.exists()) {
            throw new FileNotFoundException("\"" + workingDirectory.getPath() + "\" in filesytem");
        }
        if (!workingDirectory.canRead()) {
            throw new IOException("Can't read workingDirectory \"" + workingDirectory.getPath() + "\"");
        }
        if (!workingDirectory.isDirectory()) {
            throw new FileNotFoundException("\"" + workingDirectory.getPath() + "\" is not a directory");
        }
        this.workingDirectory = workingDirectory;
        return this;
    }

    public ProcesslauncherBuilder setExecCodeMustBeZero(boolean execCodeMustBeZero) {
        this.execCodeMustBeZero = execCodeMustBeZero;
        return this;
    }

    public boolean isExecCodeMustBeZero() {
        return this.execCodeMustBeZero;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecutionCallbacker> getExecutionCallbackers() {
        List<ExecutionCallbacker> list = this.executionCallbackers;
        synchronized (list) {
            return Collections.unmodifiableList(this.executionCallbackers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcesslauncherBuilder addExecutionCallbacker(ExecutionCallbacker executionCallbacker) {
        Objects.requireNonNull(executionCallbacker, "\"endExecutionCallbacker\" can't to be null");
        List<ExecutionCallbacker> list = this.executionCallbackers;
        synchronized (list) {
            this.executionCallbackers.add(executionCallbacker);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcesslauncherBuilder removeExecutionCallbacker(ExecutionCallbacker executionCallbacker) {
        Objects.requireNonNull(executionCallbacker, "\"endExecutionCallbacker\" can't to be null");
        List<ExecutionCallbacker> list = this.executionCallbackers;
        synchronized (list) {
            this.executionCallbackers.remove(executionCallbacker);
        }
        return this;
    }

    public Optional<ExecutionTimeLimiter> getExecutionTimeLimiter() {
        return this.executionTimeLimiter;
    }

    @Override
    public ProcesslauncherBuilder setExecutionTimeLimiter(ExecutionTimeLimiter executionTimeLimiter) {
        this.executionTimeLimiter = Optional.ofNullable(executionTimeLimiter);
        return this;
    }

    public Optional<ExternalProcessStartup> getExternalProcessStartup() {
        return this.externalProcessStartup;
    }

    public ProcesslauncherBuilder setExternalProcessStartup(ExternalProcessStartup externalProcessStartup) {
        this.externalProcessStartup = Optional.ofNullable(externalProcessStartup);
        return this;
    }

    @Override
    public ProcesslauncherBuilder setCaptureStandardOutput(CaptureStandardOutput captureStandardOutput) {
        this.captureStandardOutput = Optional.ofNullable(captureStandardOutput);
        return this;
    }

    @Override
    public Optional<CaptureStandardOutput> getCaptureStandardOutput() {
        return this.captureStandardOutput;
    }

    public ProcessBuilder makeProcessBuilder() {
        ArrayList<String> fullCommandLine = new ArrayList<String>();
        fullCommandLine.add(this.executable.getPath());
        fullCommandLine.addAll(this.parameters);
        ProcessBuilder processBuilder = new ProcessBuilder(fullCommandLine);
        processBuilder.environment().putAll(this.environment);
        if (this.workingDirectory != null && this.workingDirectory.exists() && this.workingDirectory.isDirectory()) {
            processBuilder.directory(this.workingDirectory);
        } else {
            processBuilder.directory(new File(System.getProperty("user.dir", new File(".").getAbsolutePath())));
        }
        return processBuilder;
    }

    public String getFullCommandLine() {
        StringBuilder sb = new StringBuilder();
        sb.append(addQuotesIfSpaces.apply(this.executable.getPath()));
        sb.append(" ");
        sb.append(this.parameters.stream().map(addQuotesIfSpaces).collect(Collectors.joining(" ")));
        return sb.toString().trim();
    }

    public String getExecutableName() {
        return this.executable.getName();
    }

    public String toString() {
        return this.getFullCommandLine();
    }

    @Override
    public Processlauncher toProcesslauncher() {
        return new Processlauncher(this);
    }
}

