/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import tv.hd3g.processlauncher.ExecutionCallbacker;
import tv.hd3g.processlauncher.ExecutionTimeLimiter;
import tv.hd3g.processlauncher.ExternalProcessStartup;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.io.CaptureStandardOutput;

public class Processlauncher {
    private final boolean execCodeMustBeZero;
    private final List<ExecutionCallbacker> executionCallbackers;
    private final Optional<ExecutionTimeLimiter> executionTimeLimiter;
    private final Optional<CaptureStandardOutput> captureStandardOutput;
    private final Optional<ExternalProcessStartup> externalProcessStartup;
    private final ProcessBuilder processBuilder;
    private final String fullCommandLine;
    private final ProcesslauncherBuilder processlauncherBuilder;
    private final String executableName;

    public Processlauncher(ProcesslauncherBuilder processlauncherBuilder) {
        this.processlauncherBuilder = Objects.requireNonNull(processlauncherBuilder, "\"processlauncherBuilder\" can't to be null");
        this.execCodeMustBeZero = processlauncherBuilder.isExecCodeMustBeZero();
        this.executionCallbackers = Collections.unmodifiableList(new ArrayList<ExecutionCallbacker>(processlauncherBuilder.getExecutionCallbackers()));
        this.executionTimeLimiter = processlauncherBuilder.getExecutionTimeLimiter();
        this.captureStandardOutput = processlauncherBuilder.getCaptureStandardOutput();
        this.externalProcessStartup = processlauncherBuilder.getExternalProcessStartup();
        this.processBuilder = processlauncherBuilder.makeProcessBuilder();
        this.fullCommandLine = processlauncherBuilder.getFullCommandLine();
        this.executableName = processlauncherBuilder.getExecutableName();
    }

    public ProcesslauncherLifecycle start() throws IOException {
        return new ProcesslauncherLifecycle(this);
    }

    public List<ExecutionCallbacker> getExecutionCallbackers() {
        return this.executionCallbackers;
    }

    public Optional<ExecutionTimeLimiter> getExecutionTimeLimiter() {
        return this.executionTimeLimiter;
    }

    public Optional<CaptureStandardOutput> getCaptureStandardOutput() {
        return this.captureStandardOutput;
    }

    public Optional<ExternalProcessStartup> getExternalProcessStartup() {
        return this.externalProcessStartup;
    }

    public boolean isExecCodeMustBeZero() {
        return this.execCodeMustBeZero;
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public String toString() {
        return this.fullCommandLine;
    }

    public String getFullCommandLine() {
        return this.fullCommandLine;
    }

    public ProcesslauncherBuilder getProcesslauncherBuilder() {
        return this.processlauncherBuilder;
    }

    public String getExecutableName() {
        return this.executableName;
    }
}

