/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;

public class ExecutionTimeLimiter {
    private final ScheduledExecutorService maxExecTimeScheduler;
    private final long maxExecTime;

    public ExecutionTimeLimiter(long maxExecTime, TimeUnit unit, ScheduledExecutorService maxExecTimeScheduler) {
        if (maxExecTime == 0L) {
            throw new RuntimeException("Invalid maxExecTime value: " + maxExecTime);
        }
        this.maxExecTimeScheduler = Objects.requireNonNull(maxExecTimeScheduler, "\"maxExecTimeScheduler\" can't to be null");
        this.maxExecTime = unit.toMillis(Math.abs(maxExecTime));
    }

    public long getMaxExecTime(TimeUnit unit) {
        return unit.convert(this.maxExecTime, TimeUnit.MILLISECONDS);
    }

    void addTimesUp(ProcesslauncherLifecycle toCallBack, Process process) {
        ScheduledFuture<?> maxExecTimeStopper = this.maxExecTimeScheduler.schedule(() -> toCallBack.runningTakesTooLongTimeStopIt(), this.maxExecTime, TimeUnit.MILLISECONDS);
        process.onExit().thenRunAsync(() -> maxExecTimeStopper.cancel(false), this.maxExecTimeScheduler);
    }
}

