/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.processlauncher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import tv.hd3g.processlauncher.ExecutionCallbacker;
import tv.hd3g.processlauncher.InvalidExecution;
import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.ProcesslauncherLifecycle;
import tv.hd3g.processlauncher.cmdline.CommandLine;
import tv.hd3g.processlauncher.cmdline.ExecutableFinder;
import tv.hd3g.processlauncher.cmdline.Parameters;
import tv.hd3g.processlauncher.io.CapturedStdOutErrTextRetention;
import tv.hd3g.processlauncher.io.CapturedStreams;
import tv.hd3g.processlauncher.tool.ExecutableTool;

public class Exec
implements ExecutableTool {
    private final String execName;
    private final ExecutableFinder executableFinder;
    private final Parameters parameters;
    private final Map<String, String> varsToInject;
    private boolean removeParamsIfNoVarToInject;
    private final Consumer<ProcesslauncherBuilder> preBeforeRun;

    public Exec(String execName, ExecutableFinder executableFinder) throws FileNotFoundException {
        this.execName = Objects.requireNonNull(execName, "\"execName\" can't to be null");
        this.executableFinder = Objects.requireNonNull(executableFinder, "\"executableFinder\" can't to be null");
        executableFinder.get(execName);
        this.parameters = new Parameters();
        this.varsToInject = new HashMap<String, String>();
        this.preBeforeRun = processBuilder -> {};
    }

    public Exec(ExecutableTool tool, ExecutableFinder executableFinder) throws FileNotFoundException {
        this.execName = Objects.requireNonNull(tool.getExecutableName(), "\"tool#getExecutableName\" can't to be null");
        this.executableFinder = Objects.requireNonNull(executableFinder, "\"executableFinder\" can't to be null");
        executableFinder.get(this.execName);
        this.parameters = tool.getReadyToRunParameters();
        this.varsToInject = new HashMap<String, String>();
        this.preBeforeRun = processBuilder -> tool.beforeRun((ProcesslauncherBuilder)processBuilder);
    }

    public Map<String, String> getVarsToInject() {
        return this.varsToInject;
    }

    public Exec setRemoveParamsIfNoVarToInject(boolean removeParamsIfNoVarToInject) {
        this.removeParamsIfNoVarToInject = removeParamsIfNoVarToInject;
        return this;
    }

    public boolean isRemoveParamsIfNoVarToInject() {
        return this.removeParamsIfNoVarToInject;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Parameters getReadyToRunParameters() {
        if (this.varsToInject.isEmpty()) {
            return this.parameters.clone().removeVariables(this.removeParamsIfNoVarToInject);
        }
        return this.parameters.clone().injectVariables(this.varsToInject, this.removeParamsIfNoVarToInject);
    }

    @Override
    public String getExecutableName() {
        return this.execName;
    }

    public ExecutableFinder getExecutableFinder() {
        return this.executableFinder;
    }

    public File getExecutableFile() throws FileNotFoundException {
        return this.executableFinder.get(this.execName);
    }

    public CapturedStdOutErrTextRetention runWaitGetText() throws IOException {
        return this.runWaitGetText(null);
    }

    public CapturedStdOutErrTextRetention runWaitGetText(Consumer<ProcesslauncherBuilder> beforeRun) throws IOException {
        CommandLine commandLine = new CommandLine(this.execName, this.getReadyToRunParameters(), this.executableFinder);
        ProcesslauncherBuilder builder = new ProcesslauncherBuilder(commandLine);
        final ExecutorService outStreamWatcher = Executors.newFixedThreadPool(2);
        CapturedStdOutErrTextRetention textRetention = new CapturedStdOutErrTextRetention();
        builder.getSetCaptureStandardOutputAsOutputText(CapturedStreams.BOTH_STDOUT_STDERR, outStreamWatcher).getObservers().add(textRetention);
        this.preBeforeRun.accept(builder);
        if (beforeRun != null) {
            beforeRun.accept(builder);
        }
        builder.addExecutionCallbacker(new ExecutionCallbacker(){

            @Override
            public void onEndExecution(ProcesslauncherLifecycle processlauncherLifecycle) {
                outStreamWatcher.shutdown();
            }
        });
        try {
            builder.start().checkExecution();
        }
        catch (InvalidExecution e) {
            e.setStdErr(textRetention.getStderr(false, " / "));
            throw e;
        }
        return textRetention;
    }
}

