/*
 * This file is part of fflauncher.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * Copyright (C) hdsdi3g for hd3g.tv 2019
 *
*/
package tv.hd3g.processlauncher.tool;

import java.util.function.Predicate;

import tv.hd3g.processlauncher.ProcesslauncherBuilder;
import tv.hd3g.processlauncher.cmdline.Parameters;

public interface ExecutableTool {

	Parameters getReadyToRunParameters();

	/**
	 * See by ExecutableFinder
	 */
	String getExecutableName();

	default void beforeRun(final ProcesslauncherBuilder processBuilder) {
	}

	/**
	 * No filter by default.
	 * @return A filter for the error capture post-process, applied on standard error outputed by process.
	 */
	default Predicate<String> filterOutErrorLines() {
		return p -> true;
	}

}
