/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.utility;

import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.SharedByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import tv.hd3g.commons.mailkit.SendMailDto;

public class MimeMessageAnalyzer {
    private final MimeMessage message;

    public MimeMessageAnalyzer(MimeMessage message) {
        this.message = Objects.requireNonNull(message, "\"message\" can't to be null");
    }

    private String getBodyPartContent(BodyPart bodyPart) {
        try {
            if (bodyPart.getContentType().equalsIgnoreCase("message/delivery-status")) {
                return "message/delivery-status";
            }
            Object object = bodyPart.getContent();
            if (object instanceof MimeMultipart) {
                MimeMultipart mimeMultipart = (MimeMultipart)object;
                return this.getBodyParts(mimeMultipart).stream().map(this::getBodyPartContent).collect(Collectors.joining(System.lineSeparator()));
            }
            object = bodyPart.getContent();
            if (object instanceof MimeMessage) {
                MimeMessage mimeMessage = (MimeMessage)object;
                return (String)mimeMessage.getContent();
            }
            object = bodyPart.getContent();
            if (object instanceof String) {
                String strPart = (String)object;
                return strPart;
            }
            object = bodyPart.getContent();
            if (object instanceof SharedByteArrayInputStream) {
                SharedByteArrayInputStream is = (SharedByteArrayInputStream)object;
                if (!"Content-Type: text/plain; charset=utf-8".equals(bodyPart.getContentType())) {
                    throw new IllegalArgumentException("Unknow body part: " + bodyPart.getContent().getClass().getName() + ", " + bodyPart.getContentType());
                }
                ByteArrayOutputStream bias = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)is, (OutputStream)bias);
                return new String(bias.toByteArray(), StandardCharsets.UTF_8);
            }
            throw new IllegalArgumentException("Unknow body part: " + bodyPart.getContent().getClass().getName() + ", " + bodyPart.getContentType());
        }
        catch (MessagingException | IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private List<BodyPart> getBodyParts(MimeMultipart mimeMultipart) throws MessagingException {
        ArrayList<BodyPart> list = new ArrayList<BodyPart>();
        for (int pos = 0; pos < mimeMultipart.getCount(); ++pos) {
            list.add(mimeMultipart.getBodyPart(pos));
        }
        return list;
    }

    public String getMailContent() throws MessagingException {
        try {
            Object object = this.message.getContent();
            if (object instanceof MimeMultipart) {
                MimeMultipart multipartContent = (MimeMultipart)object;
                return this.getBodyParts(multipartContent).stream().map(this::getBodyPartContent).collect(Collectors.joining(System.lineSeparator()));
            }
            throw new IllegalArgumentException("Can't manage content " + this.message.getContent().getClass());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void printFullEmail() throws MessagingException {
        try {
            this.message.writeTo((OutputStream)System.out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<String> getHeaders() throws MessagingException {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.message.getAllHeaders().asIterator(), 16), false).map(h -> h.getName() + ": " + h.getValue()).toList();
    }

    public String getHeader(String name) throws MessagingException {
        return this.message.getHeader(name, "");
    }

    public List<String> getHeaders(String name) throws MessagingException {
        return List.of(this.message.getHeader(name));
    }

    private String makeExceptionMessage(Object expected, Object actual, String what) {
        return "Invalid " + what + " expected: " + expected + ", actual: " + actual;
    }

    private void checkError(Object expected, Object actual, String what) {
        if (!Objects.equals(expected, actual)) {
            throw new IllegalArgumentException(this.makeExceptionMessage(expected, actual, what));
        }
    }

    public String getFrom() throws MessagingException {
        return Stream.of(this.message.getFrom()).map(Object::toString).findFirst().orElse(null);
    }

    public String getReplyTo() throws MessagingException {
        return Stream.of(this.message.getReplyTo()).map(Object::toString).findFirst().orElse(null);
    }

    private Set<String> getRecipients(Message.RecipientType type) throws MessagingException {
        return Optional.ofNullable(this.message.getRecipients(type)).map(List::of).stream().flatMap(Collection::stream).map(Object::toString).map(r -> r.replace("\"", "")).collect(Collectors.toUnmodifiableSet());
    }

    public Set<String> getRecipients() throws MessagingException {
        return this.getRecipients(Message.RecipientType.TO);
    }

    public Set<String> getRecipientsCC() throws MessagingException {
        return this.getRecipients(Message.RecipientType.CC);
    }

    public Set<String> getRecipientsBCC() throws MessagingException {
        return this.getRecipients(Message.RecipientType.BCC);
    }

    public void checkRecipients(Set<String> to, Set<String> cc, Set<String> bcc) throws MessagingException {
        if (!to.equals(this.getRecipients())) {
            throw new IllegalArgumentException(this.makeExceptionMessage(to, this.getRecipients(), "recipients To"));
        }
        if (!cc.equals(this.getRecipientsCC())) {
            throw new IllegalArgumentException(this.makeExceptionMessage(cc, this.getRecipientsCC(), "recipients CC"));
        }
        if (!bcc.equals(this.getRecipientsBCC())) {
            throw new IllegalArgumentException(this.makeExceptionMessage(bcc, this.getRecipientsBCC(), "recipients BCC"));
        }
    }

    public void checkHeaders(String senderAddr, String replyToAddr, Set<String> recipientsAddr, Locale lang, String userAgent, SendMailDto.MessageGrade grade) throws MessagingException {
        this.checkError(senderAddr, this.getFrom(), "sender");
        this.checkError(replyToAddr, this.getReplyTo(), "replyTo");
        this.checkError(recipientsAddr, this.getRecipients(), "recipients");
        this.checkHeader("Content-Language", lang.toString());
        this.checkHeader("User-Agent", userAgent);
        this.checkError(String.valueOf(grade.getMessagePriority()), this.getHeader("X-Priority"), "Priority");
    }

    public void checkHeader(String name, Object expected) throws MessagingException {
        this.checkError(expected, this.getHeader(name), name);
    }
}

