/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.utility;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessagePreparator;
import tv.hd3g.mailkit.utility.MimeMessageAnalyzer;

public class FlatJavaMailSender
implements JavaMailSender {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
    private final Function<MimeMessage, MimeMessageAnalyzer> mimeMessageAnalyzerProvider;
    private final JavaMailSender realJavaMailSender;
    private final List<MimeMessageAnalyzer> analyzers;
    private final File sendtoDir;

    public FlatJavaMailSender(boolean sendToFile) {
        this(sendToFile, MimeMessageAnalyzer::new);
    }

    FlatJavaMailSender(boolean sendToFile, Function<MimeMessage, MimeMessageAnalyzer> mimeMessageAnalyzerProvider) {
        this.mimeMessageAnalyzerProvider = Objects.requireNonNull(mimeMessageAnalyzerProvider, "\"mimeMessageAnalyzerProvider\" can't to be null");
        this.realJavaMailSender = new JavaMailSenderImpl();
        this.analyzers = new ArrayList<MimeMessageAnalyzer>();
        if (sendToFile) {
            this.sendtoDir = new File("target/mailkit");
            try {
                FileUtils.forceMkdir((File)this.sendtoDir);
                FileUtils.cleanDirectory((File)this.sendtoDir);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            this.sendtoDir = null;
        }
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        MimeMessageAnalyzer mimeMessageAnalyzed = this.mimeMessageAnalyzerProvider.apply(mimeMessage);
        this.save(mimeMessageAnalyzed);
        this.analyzers.add(mimeMessageAnalyzed);
    }

    public List<MimeMessageAnalyzer> getMessagesAndReset(int assertSize) {
        if (assertSize != this.analyzers.size()) {
            throw new IllegalArgumentException("List size=" + this.analyzers.size() + " is not assertSize=" + assertSize);
        }
        List<MimeMessageAnalyzer> result = this.analyzers.stream().toList();
        this.analyzers.clear();
        result.forEach(this::save);
        return result;
    }

    public void checkIsMessageListEmpty() {
        if (this.analyzers.isEmpty()) {
            return;
        }
        throw new IllegalStateException("List is not empty (" + this.analyzers.size() + " items)");
    }

    private void save(MimeMessageAnalyzer mimeMessageAnalyzer) {
        if (this.sendtoDir == null) {
            return;
        }
        File outFile = new File(this.sendtoDir, this.dateFormat.format(new Date()) + ".html");
        try (FileWriter fw = new FileWriter(outFile, StandardCharsets.UTF_8);){
            fw.write("<!--\r\n");
            fw.write(mimeMessageAnalyzer.getHeaders().stream().collect(Collectors.joining("\r\n")));
            fw.write("\r\n-->\r\n");
            fw.write(mimeMessageAnalyzer.getMailContent());
            fw.write("\r\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (MessagingException e) {
            throw new IllegalStateException(e);
        }
    }

    public MimeMessage createMimeMessage() {
        return this.realJavaMailSender.createMimeMessage();
    }

    public void clear() {
        this.analyzers.clear();
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        return this.realJavaMailSender.createMimeMessage(contentStream);
    }

    public void send(MimeMessage ... mimeMessages) throws MailException {
        throw new UnsupportedOperationException();
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        throw new UnsupportedOperationException();
    }

    public void send(MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        throw new UnsupportedOperationException();
    }

    public void send(SimpleMailMessage simpleMessage) throws MailException {
        throw new UnsupportedOperationException();
    }

    public void send(SimpleMailMessage ... simpleMessages) throws MailException {
        throw new UnsupportedOperationException();
    }
}

