/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.notification.implmail;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMessageHelper;
import tv.hd3g.commons.mailkit.SendMailDto;
import tv.hd3g.jobkit.engine.SupervisableEndEvent;
import tv.hd3g.mailkit.notification.NotificationGroup;
import tv.hd3g.mailkit.notification.NotificationRouter;
import tv.hd3g.mailkit.notification.implmail.NotificationEngineMailSetup;
import tv.hd3g.mailkit.notification.implmail.NotificationMailMessage;
import tv.hd3g.mailkit.notification.implmail.NotificationMailMessageProducer;
import tv.hd3g.mailkit.notification.implmail.NotificationMailMessageProducerEnvironment;

public class NotificationRouterMail
implements NotificationRouter {
    private static final Logger log = LoggerFactory.getLogger(NotificationRouterMail.class);
    public static final String USER_AGENT = "JavaMail/MailKit/Notification";
    private final NotificationMailMessageProducer engineSimpleTemplate;
    private final NotificationMailMessageProducer engineFullTemplate;
    private final NotificationMailMessageProducer engineDebugTemplate;
    private final Optional<NotificationGroup> oGroupDev;
    private final Optional<NotificationGroup> oGroupAdmin;
    private final Optional<NotificationGroup> oGroupSecu;
    private final NotificationEngineMailSetup setup;

    public NotificationRouterMail(NotificationMailMessageProducer engineSimpleTemplate, NotificationMailMessageProducer engineFullTemplate, NotificationMailMessageProducer engineDebugTemplate, NotificationEngineMailSetup setup) {
        this.engineSimpleTemplate = Objects.requireNonNull(engineSimpleTemplate, "\"engineSimpleTemplate\" can't to be null");
        this.engineFullTemplate = Objects.requireNonNull(engineFullTemplate, "\"engineFullTemplate\" can't to be null");
        this.engineDebugTemplate = Objects.requireNonNull(engineDebugTemplate, "\"engineDebugTemplate\" can't to be null");
        this.oGroupDev = Optional.ofNullable(setup.groupDev());
        this.oGroupAdmin = Optional.ofNullable(setup.groupAdmin());
        this.oGroupSecu = Optional.ofNullable(setup.groupSecurity());
        this.setup = Objects.requireNonNull(setup, "\"setup\" can't to be null");
    }

    @Override
    public void send(SupervisableEndEvent event) {
        if (this.setup.appNotificationService().isSecurityEvent(event) || event.isSecurityMarked()) {
            log.trace("Route sended event {}: security", (Object)event);
            this.sendSecurityEvent(event);
        } else if (this.setup.appNotificationService().isStateChangeEvent(event) || event.isInternalStateChangeMarked()) {
            log.trace("Route sended event {}: state change", (Object)event);
            this.sendStateChangeEvent(event);
        } else if (event.error() != null) {
            log.trace("Route sended event {}: error", (Object)event);
            this.sendErrorEvent(event);
        } else if (event.isNotTrivialMarked()) {
            log.trace("Route sended event {}: ok/ko", (Object)event);
            this.sendOkKoEvent(event);
        } else {
            log.debug("Don't send event, not interesting enough: {}", (Object)event);
        }
    }

    private void sendToEndUserEvent(SupervisableEndEvent event) {
        Map<String, Locale> endUserscontacts = this.setup.appNotificationService().getEndUserContactsToSendEvent(event, this.setup.supervisableManager().createContextExtractor(event));
        Optional.ofNullable(endUserscontacts).stream().map(Map::entrySet).flatMap(Collection::stream).forEach(entry -> this.send(SendKind.END_USER, (String)entry.getKey(), (Locale)entry.getValue(), this.engineSimpleTemplate, event));
    }

    private void sendOkKoEvent(SupervisableEndEvent event) {
        this.sendToEndUserEvent(event);
        if (this.oGroupAdmin.isPresent()) {
            this.send(SendKind.ADMIN, this.oGroupAdmin.get().addrList(), this.oGroupAdmin.get().lang(), this.engineFullTemplate, event);
        }
    }

    void sendErrorEvent(SupervisableEndEvent event) {
        this.sendToEndUserEvent(event);
        if (this.oGroupAdmin.isPresent()) {
            this.send(SendKind.ADMIN, this.oGroupAdmin.get().addrList(), this.oGroupAdmin.get().lang(), this.engineFullTemplate, event);
        }
        if (this.oGroupDev.isPresent()) {
            this.send(SendKind.DEV, this.oGroupDev.get().addrList(), this.oGroupDev.get().lang(), this.engineDebugTemplate, event);
        }
    }

    void sendStateChangeEvent(SupervisableEndEvent event) {
        if (this.oGroupAdmin.isPresent()) {
            this.send(SendKind.ADMIN, this.oGroupAdmin.get().addrList(), this.oGroupAdmin.get().lang(), this.engineFullTemplate, event);
        }
        if (this.oGroupDev.isPresent()) {
            this.send(SendKind.DEV, this.oGroupDev.get().addrList(), this.oGroupDev.get().lang(), this.engineDebugTemplate, event);
        }
    }

    void sendSecurityEvent(SupervisableEndEvent event) {
        if (this.oGroupAdmin.isPresent()) {
            this.send(SendKind.ADMIN, this.oGroupAdmin.get().addrList(), this.oGroupAdmin.get().lang(), this.engineFullTemplate, event, SendMailDto.MessageGrade.SECURITY);
        }
        if (this.oGroupSecu.isPresent()) {
            this.send(SendKind.SECURITY, this.oGroupSecu.get().addrList(), this.oGroupSecu.get().lang(), this.engineFullTemplate, event, SendMailDto.MessageGrade.SECURITY);
        }
        if (this.oGroupDev.isPresent()) {
            this.send(SendKind.DEV, this.oGroupDev.get().addrList(), this.oGroupDev.get().lang(), this.engineDebugTemplate, event, SendMailDto.MessageGrade.SECURITY);
        }
    }

    private void send(SendKind reason, String recipientsAddr, Locale lang, NotificationMailMessageProducer template, SupervisableEndEvent event) {
        this.send(reason, Set.of(recipientsAddr), lang, template, event);
    }

    private void send(SendKind reason, Set<String> recipientsAddr, Locale lang, NotificationMailMessageProducer template, SupervisableEndEvent event) {
        SendMailDto.MessageGrade grade = event.isSecurityMarked() ? SendMailDto.MessageGrade.SECURITY : (event.isUrgentMarked() ? SendMailDto.MessageGrade.URGENT : SendMailDto.MessageGrade.EVENT_NOTICE);
        this.send(reason, recipientsAddr, lang, template, event, grade);
    }

    private void send(SendKind reason, Set<String> recipientsAddr, Locale lang, NotificationMailMessageProducer template, SupervisableEndEvent event, SendMailDto.MessageGrade grade) {
        NotificationMailMessageProducerEnvironment env = new NotificationMailMessageProducerEnvironment(lang, this.setup.appNotificationService());
        NotificationMailMessage mailMessage = template.makeMessage(env, event);
        MimeMessage mimeMessage = this.setup.mailSender().createMimeMessage();
        String subject = mailMessage.subject();
        String htmlMessage = mailMessage.htmlMessage();
        try {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, 3, "UTF-8");
            message.setSubject(subject);
            message.setFrom(this.setup.senderAddr());
            message.setReplyTo(this.setup.replyToAddr());
            if (recipientsAddr.size() == 1) {
                message.setTo((String)recipientsAddr.stream().findFirst().orElseThrow());
            } else {
                message.setTo(recipientsAddr.toArray(new String[0]));
            }
            mimeMessage.setHeader("User-Agent", USER_AGENT);
            mimeMessage.setHeader("Content-Language", lang.toString());
            mimeMessage.setHeader("X-Notification-type", event.typeName());
            message.setPriority(grade.getMessagePriority());
            message.setText(htmlMessage, true);
            log.trace("Full message: {}", (Object)htmlMessage);
            log.info("Send a mail to {}/{}, with {}: \"{}\"", new Object[]{reason, recipientsAddr, template.getClass().getSimpleName(), subject});
            this.setup.mailSender().send(mimeMessage);
        }
        catch (MessagingException e) {
            log.error("Can't send mail to {} ({})", new Object[]{recipientsAddr, subject, e});
            throw new IllegalStateException("Can't send mail ", e);
        }
    }

    private static enum SendKind {
        END_USER,
        ADMIN,
        DEV,
        SECURITY;

    }
}

