/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.mailkit.notification.implmail;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import j2html.TagCreator;
import j2html.attributes.Attr;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.MetaTag;
import j2html.tags.specialized.SpanTag;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tv.hd3g.commons.version.EnvironmentVersion;
import tv.hd3g.jobkit.engine.SupervisableEndEvent;
import tv.hd3g.jobkit.engine.SupervisableMessage;
import tv.hd3g.jobkit.engine.SupervisableResult;
import tv.hd3g.jobkit.engine.SupervisableStep;
import tv.hd3g.mailkit.mod.component.Translate;
import tv.hd3g.mailkit.mod.service.SendAsSimpleNotificationContextPredicate;
import tv.hd3g.mailkit.notification.ExceptionToString;
import tv.hd3g.mailkit.notification.NotificationEnvironment;
import tv.hd3g.mailkit.notification.implmail.HtmlCssDocumentPayload;

public class NotificationMailTemplateToolkit {
    private static final Logger log = LoggerFactory.getLogger(NotificationMailTemplateToolkit.class);
    private static final String ATTR_JSON = ".json";
    private static final String ATTR_JSON_VALUE = ".json.value";
    private static final String CONTEXT_STR = "Context:";
    static final String APPNAME = ".appname";
    protected final Translate translate;
    protected final NotificationEnvironment env;
    private final ExceptionToString exceptionToString;
    private final EnvironmentVersion environmentVersion;

    public NotificationMailTemplateToolkit(Translate translate, NotificationEnvironment env, EnvironmentVersion environmentVersion) {
        this.translate = Objects.requireNonNull(translate, "\"translate\" can't to be null");
        this.env = Objects.requireNonNull(env, "\"env\" can't to be null");
        this.environmentVersion = Objects.requireNonNull(environmentVersion, "\"environmentVersion\" can't to be null");
        this.exceptionToString = new ExceptionToString();
    }

    public String processSubject(Locale lang, SupervisableEndEvent event) {
        if (event.error() != null) {
            return this.translate.i18n(lang, event, "subject.error", "Error for {0}: {1}", this.env.appName(), ExceptionToString.exceptionRefCleaner(event.error().getMessage()));
        }
        SupervisableResult result = event.result();
        if (result != null) {
            String resultState = this.getResultStateI18n(lang, event);
            String message = Optional.ofNullable(event.result().message()).map(m -> this.translateMessage(lang, event, (SupervisableMessage)m)).orElse(null);
            if (message != null) {
                return this.translate.i18n(lang, event, "subject.okwithresult", "Process {0} for {1}: {2}", resultState, this.env.appName(), message);
            }
            return this.translate.i18n(lang, event, "subject.okwithresultmessageless", "Process {0} for {1}", resultState, this.env.appName());
        }
        String subject = this.translate.i18n(lang, event, "subject.ok", "Process done for {0}", this.env.appName());
        log.trace("Subject: \"{}\"", (Object)subject);
        return subject;
    }

    public String processHTMLMessage(HtmlCssDocumentPayload payload) {
        String style = payload.listCSSEntries().stream().map(e -> e.split("\\r?\\n")).map(List::of).flatMap(Collection::stream).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.joining("\r\n"));
        return String.join((CharSequence)"\r\n", "<!DOCTYPE html>", ((HtmlTag)TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{((MetaTag)TagCreator.meta().withName("viewport")).withContent("width=device-width, initial-scale=1.0"), ((MetaTag)TagCreator.meta().withData("http-equiv", "Content-Type")).withContent("text/html; charset=UTF-8"), TagCreator.style((String)style).withType("text/css")}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.each(payload.listBodyContent().stream())})}).withLang("en")).renderFormatted()).trim();
    }

    public String getResultStateI18n(Locale lang, SupervisableEndEvent event) {
        return Optional.ofNullable(event.result()).map(SupervisableResult::state).flatMap(Optional::ofNullable).map(Enum::name).map(String::toLowerCase).map(stateName -> this.translate.i18n(lang, event, "resultstate." + stateName, (String)stateName, new String[0])).orElse("done");
    }

    String spanWrapp(String attrs, String text) {
        return TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)attrs), (String)text).render();
    }

    public String formatLongDate(Date date, Locale locale) {
        return Optional.ofNullable(date).map(d -> DateFormat.getDateTimeInstance(0, 2, locale).format((Date)d)).orElse("(?)");
    }

    public String formatShortDate(Date date, Locale locale) {
        return Optional.ofNullable(date).map(d -> DateFormat.getDateTimeInstance(3, 2, locale).format((Date)d)).orElse("(?)");
    }

    public String formatShortTime(Date date, Locale locale) {
        return Optional.ofNullable(date).map(d -> DateFormat.getTimeInstance(2, locale).format((Date)d)).orElse("(?)");
    }

    DomContent exceptionFormatterToDom(Exception e, boolean verbose) {
        String stackTrace = verbose ? this.exceptionToString.getStackTrace(e) : this.exceptionToString.getSimpleStackTrace(e);
        return TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".stacktrace"), (DomContent[])new DomContent[]{TagCreator.pre((String)stackTrace)});
    }

    public String callerToString(StackTraceElement caller) {
        String fileName = caller.getFileName();
        int lineNumber = caller.getLineNumber();
        if (fileName != null && lineNumber >= 0) {
            return fileName + " L" + lineNumber;
        }
        if (fileName != null) {
            return fileName;
        }
        return caller.getClassName();
    }

    DomContent stepLineToString(Locale lang, SupervisableEndEvent event, SupervisableStep step, boolean verbose) {
        SpanTag timeSpan = TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)".stepdate"), (String)this.formatShortTime(step.stepDate(), lang));
        SpanTag messageSpan = TagCreator.span((String)this.translateMessage(lang, event, step.message()));
        SpanTag verboseSpan = null;
        if (verbose) {
            String fName = step.caller().getFileName();
            int line = step.caller().getLineNumber();
            verboseSpan = line > 0 ? TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)".verbose"), (String)(fName.substring(0, fName.lastIndexOf(".")) + " L" + line)) : TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)".verbose"), (String)fName.substring(0, fName.lastIndexOf(".")));
        }
        return TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".stepline"), (DomContent[])new DomContent[]{timeSpan, messageSpan, verboseSpan});
    }

    public void stepsList(Locale lang, SupervisableEndEvent event, boolean verbose, List<DomContent> listBodyContent, List<String> listCSSEntries) {
        if (event.steps().isEmpty()) {
            return;
        }
        DomContent stepLines = TagCreator.each((Collection)event.steps(), step -> this.stepLineToString(lang, event, (SupervisableStep)step, verbose));
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".steps"), (DomContent[])new DomContent[]{stepLines}));
        listCSSEntries.add("div.steps {\n    display: block;\n    font-family: 'Consolas', 'Monaco', monospace;\n    margin: 1em;\n    padding: 0.9em;\n    border-radius: 0.8rem;\n    background-color: #F8F8F8;\n    color: #000;\n    border: 1px solid #cfcfcf;\n}\ndiv.steps span.stepdate {\n   color: #CCC;\n}\ndiv.steps span.verbose {\n   color: #C8C;\n}\n");
    }

    public void makeDocumentBaseStyles(List<String> listCSSEntries) {
        listCSSEntries.add("body {\n    font-family: \"Tahoma\", sans-serif;\n    font-size: 12pt;\n    color: #090909;\n}\n\nspan.caller {\n    font-family: 'Consolas', 'Monaco', monospace;\n    color: #000;\n}\n\nspan.date {\n    font-family: sans-serif;\n    color: #fff;\n    background-color: #85c0ad;\n    display: inline-block;\n    padding: 0.25em 0.4em 0.25em 0.4em;\n    font-size: 90%;\n    font-weight: 700;\n    line-height: 0.8;\n    white-space: nowrap;\n    border-radius: 0.2rem;\n}\n\ndiv.stacktrace {\n    margin: 1em;\n    padding: 1em;\n    font-size: 100%;\n    border-radius: 0.8rem;\n    border-width: 5px;\n    border-color: #f3f8f6;\n    border-style: dashed;\n}\n\n.appname {\n    color: #6d3824;\n}\n\nh3 {\n    margin-left: 1em;\n    margin-right: 1em;\n    padding: 1em;\n    background-color: #f3f8f6;\n    font-weight: normal;\n    border-radius: 0.8rem;\n}\npre {\n    margin: 0px;\n    line-height: 1.3;\n    font-family: 'Consolas', 'Monaco', monospace;\n}\n");
    }

    public void makeDocumentTitleWithoutResult(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent) {
        String title = this.translate.i18n(lang, event, "title.ok", "Process done for {0}", this.spanWrapp(APPNAME, this.env.appName()));
        listBodyContent.add((DomContent)TagCreator.h1((DomContent[])new DomContent[]{TagCreator.rawHtml((String)title)}));
    }

    public String translateMessage(Locale lang, SupervisableEndEvent event, SupervisableMessage message) {
        return this.translate.i18n(lang, event, message.code(), message.defaultResult(), message.getVarsArray());
    }

    public void makeDocumentTitleWithResult(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent) {
        SupervisableResult result = event.result();
        String cssResultState = result.state().name().toLowerCase();
        String title = this.translate.i18n(lang, event, "title.okwithresult", "Process {0} for {1}", this.spanWrapp(".resultstate." + cssResultState, this.getResultStateI18n(lang, event)), this.spanWrapp(APPNAME, this.env.appName()));
        listBodyContent.add((DomContent)TagCreator.h1((DomContent[])new DomContent[]{TagCreator.rawHtml((String)title)}));
        Optional.ofNullable(event.result().message()).ifPresent(m -> listBodyContent.add((DomContent)TagCreator.h3((String)this.translateMessage(lang, event, (SupervisableMessage)m))));
    }

    public void makeDocumentTitleError(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent, boolean displayVerboseError, boolean displayFullStackTrace) {
        String title = this.translate.i18n(lang, event, "title.error", "Error for {0}", this.spanWrapp(APPNAME, this.env.appName()));
        listBodyContent.add((DomContent)TagCreator.h1((DomContent[])new DomContent[]{TagCreator.rawHtml((String)title)}));
        if (displayVerboseError) {
            if (displayFullStackTrace) {
                listBodyContent.add(this.exceptionFormatterToDom(event.error(), true));
            } else {
                listBodyContent.add(this.exceptionFormatterToDom(event.error(), false));
            }
        } else {
            Object message = event.error().getMessage();
            message = message == null || ((String)message).isEmpty() ? "\"" + event.error().getClass().getSimpleName() + "\"" : ExceptionToString.exceptionRefCleaner((String)message);
            String subTitle = this.translate.i18n(lang, event, "title.error.message", "{0}", this.spanWrapp(".errormessage", (String)message));
            listBodyContent.add((DomContent)TagCreator.h3((DomContent[])new DomContent[]{TagCreator.rawHtml((String)subTitle)}));
        }
    }

    public void makeDocumentDates(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent) {
        String dates = this.translate.i18n(lang, event, "dates", "Created the {0}, started at {1}, ended at {2}.", this.spanWrapp(".event.date.create", this.formatLongDate(event.creationDate(), lang)), this.spanWrapp(".event.date.start", this.formatShortTime(event.startDate(), lang)), this.spanWrapp(".event.date.end", this.formatShortTime(event.endDate(), lang)));
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".dates"), (DomContent[])new DomContent[]{TagCreator.rawHtml((String)dates)}));
    }

    private DomContent jsonToDom(JsonNode json, UnaryOperator<String> i18nKey, Predicate<String> filterKey) {
        return switch (json.getNodeType()) {
            case JsonNodeType.ARRAY -> {
                DomContent[] v0 = new DomContent[1];
                v0[0] = TagCreator.each(IntStream.range(0, json.size()).mapToObj(arg_0 -> ((JsonNode)json).get(arg_0)).map(entry -> this.jsonToDom((JsonNode)entry, i18nKey, filterKey)).map(xva$0 -> TagCreator.li((DomContent[])new DomContent[]{xva$0})).map(entry -> entry));
                yield TagCreator.ol((Attr.ShortForm)TagCreator.attrs((String)ATTR_JSON), (DomContent[])v0);
            }
            case JsonNodeType.OBJECT -> TagCreator.ul((Attr.ShortForm)TagCreator.attrs((String)ATTR_JSON), (DomContent[])new DomContent[]{TagCreator.each(StreamSupport.stream(Spliterators.spliteratorUnknownSize(json.fieldNames(), 1), false).filter(filterKey).sorted().map(key -> {
                JsonNode value = json.get(key);
                String keyName = (String)i18nKey.apply((String)key) + ":";
                return TagCreator.li((DomContent[])new DomContent[]{TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)".json.key"), (String)keyName), this.jsonToDom(value, i18nKey, filterKey)});
            }).map(entry -> entry))});
            case JsonNodeType.NUMBER -> TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)ATTR_JSON_VALUE), (String)json.toString());
            case JsonNodeType.STRING -> TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)ATTR_JSON_VALUE), (String)json.asText());
            case JsonNodeType.BOOLEAN -> TagCreator.span((Attr.ShortForm)TagCreator.attrs((String)ATTR_JSON_VALUE), (String)((String)i18nKey.apply(String.valueOf(json.asBoolean()))));
            default -> TagCreator.div((String)ATTR_JSON);
        };
    }

    public void makeDocumentSimpleContext(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent, List<String> listCSSEntries, SendAsSimpleNotificationContextPredicate contextPredicate) {
        JsonNode context = event.context();
        if (context == null || context.isNull() || context.isEmpty() && context.isContainerNode()) {
            return;
        }
        DomContent tree = this.jsonToDom(context, k -> this.translate.i18n(lang, event, "simplecontext.entry." + k, (String)k, new String[0]), k -> contextPredicate.isSendAsSimpleNotificationThisContextEntry((String)k, event));
        listCSSEntries.add("div.simplecontext {\n    margin-top: 1em;\n    margin-bottom: 1em;\n}\ndiv.simplecontext span.json.value {\n    font-family: 'Consolas', 'Monaco', monospace;\n    color: #555;\n}\ndiv.simplecontext ul {\n    margin-block-start: 0em;\n    margin-block-end: 0em;\n    list-style-type: none;\n}\ndiv.simplecontext ol {\n    margin-block-start: 0em;\n    margin-block-end: 0em;\n}\n");
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".simplecontext"), (DomContent[])new DomContent[]{TagCreator.text((String)this.translate.i18n(lang, event, "context", CONTEXT_STR, new String[0])), tree}));
    }

    public void makeDocumentContext(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent, List<String> listCSSEntries) {
        listCSSEntries.add("div.contextblock {\n    margin-top: 1em;\n}\n\ndiv.contextblock div.context {\n    margin: 1em;\n    padding: 0.9em;\n    border-radius: 0.8rem;\n    background-color: #484848;\n    color: #dbdbdb;\n}\ndiv.contextblock div.context a {\n   color: #dbdbdb;\n}\ndiv.contextblock div.context a:active {\n   color: #dbdbdb;\n}\ndiv.contextblock div.context a:hover {\n   color: #dbdbdb;\n}\ndiv.contextblock div.context a:visited {\n   color: #dbdbdb;\n}\ndiv.contextblock div.context a:link {\n   color: #dbdbdb;\n}\n");
        JsonNode context = event.context();
        if (context != null) {
            listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".contextblock"), (DomContent[])new DomContent[]{TagCreator.text((String)this.translate.i18n(lang, event, "context", CONTEXT_STR, new String[0])), TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".context"), (DomContent[])new DomContent[]{TagCreator.pre((String)event.context().toPrettyString())})}));
        }
    }

    public void makeDocumentCallers(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent, List<String> listCSSEntries) {
        listCSSEntries.add("div.result.date {\n    display: inline-block;\n}\ndiv.result.caller {\n    display: inline-block;\n}\nspan.result.caller {\n    color: #C8C;\n    font-family: 'Consolas', 'Monaco', monospace;\n}\n");
        String resultCaller = this.translate.i18n(lang, event, "result.caller", "Result caller source: {0}.", this.spanWrapp(".result.caller", this.callerToString(event.result().caller())));
        String resultDate = this.translate.i18n(lang, event, "result.date", "Result caller provided at {0}.", this.spanWrapp(".result.date", this.formatShortDate(event.result().date(), lang)));
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".result.caller"), (DomContent[])new DomContent[]{TagCreator.rawHtml((String)resultCaller)}));
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".result.date"), (DomContent[])new DomContent[]{TagCreator.rawHtml((String)resultDate)}));
    }

    public void makeDocumentEventEnv(Locale lang, SupervisableEndEvent event, List<DomContent> listBodyContent, List<String> listCSSEntries) {
        listCSSEntries.add("div.sendersource {\n    color: #BBB\n}\ndiv.senderversion {\n    color: #BBB\n}\nspan.envevent {\n    font-family: 'Consolas', 'Monaco', monospace;\n    color: #AAA;\n}\n");
        String senderSource = this.translate.i18n(lang, event, "sender", "Notification type: {0}, provided by {1}, runned on spool {2} as {3}, sended by {4}#{5} (started the {6}) for {7}.", this.spanWrapp(".envevent.type", event.typeName()), this.spanWrapp(".envevent.manager", event.managerName()), this.spanWrapp(".envevent.spool", event.spoolName()), this.spanWrapp(".envevent.job", event.jobName()), this.spanWrapp(".envevent.instance", this.env.instanceName()), this.spanWrapp(".envevent.instancepid", String.valueOf(this.environmentVersion.pid())), this.spanWrapp(".envevent.startedon", this.formatLongDate(this.environmentVersion.startupTime(), lang)), this.spanWrapp(".envevent.vendor", this.env.vendorName()));
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".sendersource"), (DomContent[])new DomContent[]{TagCreator.rawHtml((String)senderSource)}));
        String senderVersion = this.translate.i18n(lang, event, "senderversion", "App version: {0}, deps versions: {1}/{2} runned on {3} {4}.", this.spanWrapp(".envevent.appversion", this.environmentVersion.appVersion()), this.spanWrapp(".envevent.prodlib", this.environmentVersion.prodlibVersion()), this.spanWrapp(".envevent.framework", this.environmentVersion.frameworkVersion()), this.spanWrapp(".envevent.jvmname", this.environmentVersion.jvmNameVendor()), this.spanWrapp(".envevent.jvmversion", this.environmentVersion.jvmVersion()));
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".senderversion"), (DomContent[])new DomContent[]{TagCreator.rawHtml((String)senderVersion)}));
    }

    public void makeDocumentFooter(List<DomContent> listBodyContent, List<String> listCSSEntries) {
        listCSSEntries.add("div.env.footer {\n    margin-top: 1em;\n}\n");
        Stream<DomContent> envFooter = Optional.ofNullable(this.env.footer()).stream().map(Collection::stream).flatMap(l -> l).map(TagCreator::rawHtml).map(r -> TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".conf"), (DomContent[])new DomContent[]{r})).map(DomContent.class::cast);
        listBodyContent.add((DomContent)TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)".env.footer"), (DomContent[])new DomContent[]{TagCreator.each(envFooter)}));
    }
}

